#!/bin/bash

OVERLAY_PATH="/mnt/ubi_boot/jb_overlay"
LOG_FILE=/tmp/jb_init.log

log () {
	echo "$1" >>${LOG_FILE} 2>&1
}

launch_bdp () {
	log "launching original player prog"
	sh -c /usr/local/bin/bdpprog.1
	exit
}

if [ ! -x ${OVERLAY_PATH}/bin/brick_monitor ];then
	log "brick_monitor not found or not executable" 
	launch_bdp
	exit
fi

log "launching brick monitor"
#lircd_simulator &
/etc/init.d/rcS >>${LOG_FILE}
sleep 1s
"${OVERLAY_PATH}/bin/brick_monitor" >>${LOG_FILE} &
PID_BM=$!
sleep 3
kill -9 $PID_BM
killall lircd_simulator
log "brick_monitor stopped"
sync
sync

if [ ! -f "/mnt/ubi_boot/.nobrick" ]; then
	log "nobrick file not found"
	launch_bdp
	exit
fi

source "${OVERLAY_PATH}/config.ini"

mkdir -p /etc/ssl/certs
ln -s /mnt/ubi_boot/jb_overlay/etc/ssl/certs/ca-certificates.crt  /etc/ssl/certs/ca-certificates
sync

mkdir -p  /root/.config
ln -s /mnt/ubi_boot/jb_overlay/root/.config/rclone /root/.config/rclone
ln -s /mnt/ubi_boot/jb_overlay/config.ini /etc/config.ini
ln -s /mnt/ubi_boot/jb_overlay/autostart.sh /etc/autostart.sh
sync

if [ -z "$ROOT_PWD" ]; then
	log "setting empty root password"
	echo root::0:0:root,,,:/root:/bin/bash > /etc/passwd
else
	log "setting non empty root password"
	echo root:$(openssl passwd -1 ${ROOT_PWD}):0:0:root,,,:/root:/bin/bash > /etc/passwd
fi 

sync 

if [ "$LOAD_FUSE" == "1" ]; then
	log "loading fuse module"
	insmod /mnt/rootfs_normal/lib/modules/3.10.26/BDP/fuse.ko
fi


if [ "${USE_TELNET}" == "1" ];then
	log "launching telnet"
	/usr/sbin/inetd &
	sleep 2
	/usr/sbin/telnetd &	
fi

if [ "${USE_SSH}" == "1" ];then
	log "launching ssh server"
	${OVERLAY_PATH}/bin/dropbear -R -B -b ${OVERLAY_PATH}/etc/motd
fi

if [ -x "${OVERLAY_PATH}/autostart.sh" ]; then
	"${OVERLAY_PATH}/etc/autostart_wrap.sh" &
fi

sleep 1s
sync
sleep 1s

if [ -x "${OVERLAY_PATH}/bdp/bdpprog" ]; then
	log "launching alternative bdpprog (${OVERLAY_PATH}/bin/bdpprog)"
	sh -c "${OVERLAY_PATH}/bdp/bdpprog"
	exit
else
	launch_bdp
fi

