#!/bin/bash

#DO NOT EDIT THIS FILE but autostart.sh


OVERLAY_PATH="/mnt/ubi_boot/jb_overlay"
LOG_FILE=/tmp/jb_init.log

log () {
        echo "$1" >>${LOG_FILE} 2>&1
}

source "${OVERLAY_PATH}/config.ini"

if [ "$AUTOSTART_WAIT_NETWORK" == "1" ]; then
	count=0
	skip=0
	while ! ip route | grep -q -F "eth0"; do
		/bin/sleep 1s
	        count=$(( $count + 1 ))
	        if [ "$count" == 30 ]; then
	                log "timeout reached when waiting for network" 
			exit
	        fi
	done
	log "network initialized"
fi

log "network is setup, waiting for usb"

if [ "$AUTOSTART_WAIT_USB" == "1" ]; then
count=0
skip=0
	while ! /mnt/ubi_boot/jb_overlay/bin/df | grep -q -F "/dev/sda1"; do
		/bin/sleep 1s
	        count=$(( $count + 1 ))
	        if [ "$count" == 30 ]; then
	                log "timeout reached when waiting for usb" 
			exit
	        fi
	done
	log "usb initialized"
fi

log "executing autostart.sh"
"${OVERLAY_PATH}/autostart.sh"
sync
sleep 1s
echo "autostart finished" >> /tmp/jb_init.log
