/* -*- Mode: C; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * File: cfgmgr_ckmain.c
 *
 * Created: Wed Aug 14 18:24:53 2002
 *
 * $Id: cfgmgr_ckmain.c,v 1.1 2002/08/14 22:18:36 denys Exp $
 */

#include "cksum.h"

int main(int argc, char **argv)
{
  FILE *fp;
  unsigned long sum = 0;
  unsigned long res = 0;

  if(argc != 2)
  {
    printf("Usage: cfgmgr_cksum filename\n\n");
    return 1;
  }

  fp = fopen(argv[1], "rw+");

  if(!cs_is_tagged(fp))
  {
    printf("File doesn't contain the checksum, adding\n");
    if(cs_calc_sum(fp, &sum, 0))
    {
      printf("Calculated checksum is %lX\n", sum);
      if(cs_set_sum(fp, sum, 0))
        printf("Added successfully\n");
      else
        printf("Adding failed\n");
    }
  }
  else
  {
    printf("File already contains the checksum, verifying\n");
    if(cs_calc_sum(fp, &sum, 1))
    {
      printf("Calculated checksum is %lX\n", sum);
      cs_get_sum(fp, &res);
      printf("Saved checksum is %lX\n", res);
      if(sum != res)
        printf("Checksum validation failed!\n");
      else
        printf("Checksum validation successful!\n");
    }
  }

  fclose(fp);

  return 0;
}
