package Slim::Utils::Unicode::Recompose;

# This table is loaded on-demand if we need to recompose any characters
# This table was generated using the Unicode::Decompose module which
# builds it from Perl's unicore/Decomposition.pl file

# The following strange compositions have been removed:
# ";"  => "\xCD\xBE",
# K    => "\xE2\x84\xAA",
# "`"  => "\xE1\xBF\xAF",

our %table = (
  "<\xCC\xB8"                                        => "\xE2\x89\xAE",
  "=\xCC\xB8"                                        => "\xE2\x89\xA0",
  ">\xCC\xB8"                                        => "\xE2\x89\xAF",
  "A\xCC\x80"                                        => "\xC3\x80",
  "A\xCC\x81"                                        => "\xC3\x81",
  "A\xCC\x82"                                        => "\xC3\x82",
  "A\xCC\x82\xCC\x80"                                => "\xE1\xBA\xA6",
  "A\xCC\x82\xCC\x81"                                => "\xE1\xBA\xA4",
  "A\xCC\x82\xCC\x83"                                => "\xE1\xBA\xAA",
  "A\xCC\x82\xCC\x89"                                => "\xE1\xBA\xA8",
  "A\xCC\x83"                                        => "\xC3\x83",
  "A\xCC\x84"                                        => "\xC4\x80",
  "A\xCC\x86"                                        => "\xC4\x82",
  "A\xCC\x86\xCC\x80"                                => "\xE1\xBA\xB0",
  "A\xCC\x86\xCC\x81"                                => "\xE1\xBA\xAE",
  "A\xCC\x86\xCC\x83"                                => "\xE1\xBA\xB4",
  "A\xCC\x86\xCC\x89"                                => "\xE1\xBA\xB2",
  "A\xCC\x87"                                        => "\xC8\xA6",
  "A\xCC\x87\xCC\x84"                                => "\xC7\xA0",
  "A\xCC\x88"                                        => "\xC3\x84",
  "A\xCC\x88\xCC\x84"                                => "\xC7\x9E",
  "A\xCC\x89"                                        => "\xE1\xBA\xA2",
  "A\xCC\x8A"                                        => "\xC3\x85",
  "A\xCC\x8A\xCC\x81"                                => "\xC7\xBA",
  "A\xCC\x8C"                                        => "\xC7\x8D",
  "A\xCC\x8F"                                        => "\xC8\x80",
  "A\xCC\x91"                                        => "\xC8\x82",
  "A\xCC\xA3"                                        => "\xE1\xBA\xA0",
  "A\xCC\xA3\xCC\x82"                                => "\xE1\xBA\xAC",
  "A\xCC\xA3\xCC\x86"                                => "\xE1\xBA\xB6",
  "A\xCC\xA5"                                        => "\xE1\xB8\x80",
  "A\xCC\xA8"                                        => "\xC4\x84",
  "B\xCC\x87"                                        => "\xE1\xB8\x82",
  "B\xCC\xA3"                                        => "\xE1\xB8\x84",
  "B\xCC\xB1"                                        => "\xE1\xB8\x86",
  "C\xCC\x81"                                        => "\xC4\x86",
  "C\xCC\x82"                                        => "\xC4\x88",
  "C\xCC\x87"                                        => "\xC4\x8A",
  "C\xCC\x8C"                                        => "\xC4\x8C",
  "C\xCC\xA7"                                        => "\xC3\x87",
  "C\xCC\xA7\xCC\x81"                                => "\xE1\xB8\x88",
  "D\xCC\x87"                                        => "\xE1\xB8\x8A",
  "D\xCC\x8C"                                        => "\xC4\x8E",
  "D\xCC\xA3"                                        => "\xE1\xB8\x8C",
  "D\xCC\xA7"                                        => "\xE1\xB8\x90",
  "D\xCC\xAD"                                        => "\xE1\xB8\x92",
  "D\xCC\xB1"                                        => "\xE1\xB8\x8E",
  "E\xCC\x80"                                        => "\xC3\x88",
  "E\xCC\x81"                                        => "\xC3\x89",
  "E\xCC\x82"                                        => "\xC3\x8A",
  "E\xCC\x82\xCC\x80"                                => "\xE1\xBB\x80",
  "E\xCC\x82\xCC\x81"                                => "\xE1\xBA\xBE",
  "E\xCC\x82\xCC\x83"                                => "\xE1\xBB\x84",
  "E\xCC\x82\xCC\x89"                                => "\xE1\xBB\x82",
  "E\xCC\x83"                                        => "\xE1\xBA\xBC",
  "E\xCC\x84"                                        => "\xC4\x92",
  "E\xCC\x84\xCC\x80"                                => "\xE1\xB8\x94",
  "E\xCC\x84\xCC\x81"                                => "\xE1\xB8\x96",
  "E\xCC\x86"                                        => "\xC4\x94",
  "E\xCC\x87"                                        => "\xC4\x96",
  "E\xCC\x88"                                        => "\xC3\x8B",
  "E\xCC\x89"                                        => "\xE1\xBA\xBA",
  "E\xCC\x8C"                                        => "\xC4\x9A",
  "E\xCC\x8F"                                        => "\xC8\x84",
  "E\xCC\x91"                                        => "\xC8\x86",
  "E\xCC\xA3"                                        => "\xE1\xBA\xB8",
  "E\xCC\xA3\xCC\x82"                                => "\xE1\xBB\x86",
  "E\xCC\xA7"                                        => "\xC8\xA8",
  "E\xCC\xA7\xCC\x86"                                => "\xE1\xB8\x9C",
  "E\xCC\xA8"                                        => "\xC4\x98",
  "E\xCC\xAD"                                        => "\xE1\xB8\x98",
  "E\xCC\xB0"                                        => "\xE1\xB8\x9A",
  "F\xCC\x87"                                        => "\xE1\xB8\x9E",
  "G\xCC\x81"                                        => "\xC7\xB4",
  "G\xCC\x82"                                        => "\xC4\x9C",
  "G\xCC\x84"                                        => "\xE1\xB8\xA0",
  "G\xCC\x86"                                        => "\xC4\x9E",
  "G\xCC\x87"                                        => "\xC4\xA0",
  "G\xCC\x8C"                                        => "\xC7\xA6",
  "G\xCC\xA7"                                        => "\xC4\xA2",
  "H\xCC\x82"                                        => "\xC4\xA4",
  "H\xCC\x87"                                        => "\xE1\xB8\xA2",
  "H\xCC\x88"                                        => "\xE1\xB8\xA6",
  "H\xCC\x8C"                                        => "\xC8\x9E",
  "H\xCC\xA3"                                        => "\xE1\xB8\xA4",
  "H\xCC\xA7"                                        => "\xE1\xB8\xA8",
  "H\xCC\xAE"                                        => "\xE1\xB8\xAA",
  "I\xCC\x80"                                        => "\xC3\x8C",
  "I\xCC\x81"                                        => "\xC3\x8D",
  "I\xCC\x82"                                        => "\xC3\x8E",
  "I\xCC\x83"                                        => "\xC4\xA8",
  "I\xCC\x84"                                        => "\xC4\xAA",
  "I\xCC\x86"                                        => "\xC4\xAC",
  "I\xCC\x87"                                        => "\xC4\xB0",
  "I\xCC\x88"                                        => "\xC3\x8F",
  "I\xCC\x88\xCC\x81"                                => "\xE1\xB8\xAE",
  "I\xCC\x89"                                        => "\xE1\xBB\x88",
  "I\xCC\x8C"                                        => "\xC7\x8F",
  "I\xCC\x8F"                                        => "\xC8\x88",
  "I\xCC\x91"                                        => "\xC8\x8A",
  "I\xCC\xA3"                                        => "\xE1\xBB\x8A",
  "I\xCC\xA8"                                        => "\xC4\xAE",
  "I\xCC\xB0"                                        => "\xE1\xB8\xAC",
  "J\xCC\x82"                                        => "\xC4\xB4",
  "K\xCC\x81"                                        => "\xE1\xB8\xB0",
  "K\xCC\x8C"                                        => "\xC7\xA8",
  "K\xCC\xA3"                                        => "\xE1\xB8\xB2",
  "K\xCC\xA7"                                        => "\xC4\xB6",
  "K\xCC\xB1"                                        => "\xE1\xB8\xB4",
  "L\xCC\x81"                                        => "\xC4\xB9",
  "L\xCC\x8C"                                        => "\xC4\xBD",
  "L\xCC\xA3"                                        => "\xE1\xB8\xB6",
  "L\xCC\xA3\xCC\x84"                                => "\xE1\xB8\xB8",
  "L\xCC\xA7"                                        => "\xC4\xBB",
  "L\xCC\xAD"                                        => "\xE1\xB8\xBC",
  "L\xCC\xB1"                                        => "\xE1\xB8\xBA",
  "M\xCC\x81"                                        => "\xE1\xB8\xBE",
  "M\xCC\x87"                                        => "\xE1\xB9\x80",
  "M\xCC\xA3"                                        => "\xE1\xB9\x82",
  "N\xCC\x80"                                        => "\xC7\xB8",
  "N\xCC\x81"                                        => "\xC5\x83",
  "N\xCC\x83"                                        => "\xC3\x91",
  "N\xCC\x87"                                        => "\xE1\xB9\x84",
  "N\xCC\x8C"                                        => "\xC5\x87",
  "N\xCC\xA3"                                        => "\xE1\xB9\x86",
  "N\xCC\xA7"                                        => "\xC5\x85",
  "N\xCC\xAD"                                        => "\xE1\xB9\x8A",
  "N\xCC\xB1"                                        => "\xE1\xB9\x88",
  "O\xCC\x80"                                        => "\xC3\x92",
  "O\xCC\x81"                                        => "\xC3\x93",
  "O\xCC\x82"                                        => "\xC3\x94",
  "O\xCC\x82\xCC\x80"                                => "\xE1\xBB\x92",
  "O\xCC\x82\xCC\x81"                                => "\xE1\xBB\x90",
  "O\xCC\x82\xCC\x83"                                => "\xE1\xBB\x96",
  "O\xCC\x82\xCC\x89"                                => "\xE1\xBB\x94",
  "O\xCC\x83"                                        => "\xC3\x95",
  "O\xCC\x83\xCC\x81"                                => "\xE1\xB9\x8C",
  "O\xCC\x83\xCC\x84"                                => "\xC8\xAC",
  "O\xCC\x83\xCC\x88"                                => "\xE1\xB9\x8E",
  "O\xCC\x84"                                        => "\xC5\x8C",
  "O\xCC\x84\xCC\x80"                                => "\xE1\xB9\x90",
  "O\xCC\x84\xCC\x81"                                => "\xE1\xB9\x92",
  "O\xCC\x86"                                        => "\xC5\x8E",
  "O\xCC\x87"                                        => "\xC8\xAE",
  "O\xCC\x87\xCC\x84"                                => "\xC8\xB0",
  "O\xCC\x88"                                        => "\xC3\x96",
  "O\xCC\x88\xCC\x84"                                => "\xC8\xAA",
  "O\xCC\x89"                                        => "\xE1\xBB\x8E",
  "O\xCC\x8B"                                        => "\xC5\x90",
  "O\xCC\x8C"                                        => "\xC7\x91",
  "O\xCC\x8F"                                        => "\xC8\x8C",
  "O\xCC\x91"                                        => "\xC8\x8E",
  "O\xCC\x9B"                                        => "\xC6\xA0",
  "O\xCC\x9B\xCC\x80"                                => "\xE1\xBB\x9C",
  "O\xCC\x9B\xCC\x81"                                => "\xE1\xBB\x9A",
  "O\xCC\x9B\xCC\x83"                                => "\xE1\xBB\xA0",
  "O\xCC\x9B\xCC\x89"                                => "\xE1\xBB\x9E",
  "O\xCC\x9B\xCC\xA3"                                => "\xE1\xBB\xA2",
  "O\xCC\xA3"                                        => "\xE1\xBB\x8C",
  "O\xCC\xA3\xCC\x82"                                => "\xE1\xBB\x98",
  "O\xCC\xA8"                                        => "\xC7\xAA",
  "O\xCC\xA8\xCC\x84"                                => "\xC7\xAC",
  "P\xCC\x81"                                        => "\xE1\xB9\x94",
  "P\xCC\x87"                                        => "\xE1\xB9\x96",
  "R\xCC\x81"                                        => "\xC5\x94",
  "R\xCC\x87"                                        => "\xE1\xB9\x98",
  "R\xCC\x8C"                                        => "\xC5\x98",
  "R\xCC\x8F"                                        => "\xC8\x90",
  "R\xCC\x91"                                        => "\xC8\x92",
  "R\xCC\xA3"                                        => "\xE1\xB9\x9A",
  "R\xCC\xA3\xCC\x84"                                => "\xE1\xB9\x9C",
  "R\xCC\xA7"                                        => "\xC5\x96",
  "R\xCC\xB1"                                        => "\xE1\xB9\x9E",
  "S\xCC\x81"                                        => "\xC5\x9A",
  "S\xCC\x81\xCC\x87"                                => "\xE1\xB9\xA4",
  "S\xCC\x82"                                        => "\xC5\x9C",
  "S\xCC\x87"                                        => "\xE1\xB9\xA0",
  "S\xCC\x8C"                                        => "\xC5\xA0",
  "S\xCC\x8C\xCC\x87"                                => "\xE1\xB9\xA6",
  "S\xCC\xA3"                                        => "\xE1\xB9\xA2",
  "S\xCC\xA3\xCC\x87"                                => "\xE1\xB9\xA8",
  "S\xCC\xA6"                                        => "\xC8\x98",
  "S\xCC\xA7"                                        => "\xC5\x9E",
  "T\xCC\x87"                                        => "\xE1\xB9\xAA",
  "T\xCC\x8C"                                        => "\xC5\xA4",
  "T\xCC\xA3"                                        => "\xE1\xB9\xAC",
  "T\xCC\xA6"                                        => "\xC8\x9A",
  "T\xCC\xA7"                                        => "\xC5\xA2",
  "T\xCC\xAD"                                        => "\xE1\xB9\xB0",
  "T\xCC\xB1"                                        => "\xE1\xB9\xAE",
  "U\xCC\x80"                                        => "\xC3\x99",
  "U\xCC\x81"                                        => "\xC3\x9A",
  "U\xCC\x82"                                        => "\xC3\x9B",
  "U\xCC\x83"                                        => "\xC5\xA8",
  "U\xCC\x83\xCC\x81"                                => "\xE1\xB9\xB8",
  "U\xCC\x84"                                        => "\xC5\xAA",
  "U\xCC\x84\xCC\x88"                                => "\xE1\xB9\xBA",
  "U\xCC\x86"                                        => "\xC5\xAC",
  "U\xCC\x88"                                        => "\xC3\x9C",
  "U\xCC\x88\xCC\x80"                                => "\xC7\x9B",
  "U\xCC\x88\xCC\x81"                                => "\xC7\x97",
  "U\xCC\x88\xCC\x84"                                => "\xC7\x95",
  "U\xCC\x88\xCC\x8C"                                => "\xC7\x99",
  "U\xCC\x89"                                        => "\xE1\xBB\xA6",
  "U\xCC\x8A"                                        => "\xC5\xAE",
  "U\xCC\x8B"                                        => "\xC5\xB0",
  "U\xCC\x8C"                                        => "\xC7\x93",
  "U\xCC\x8F"                                        => "\xC8\x94",
  "U\xCC\x91"                                        => "\xC8\x96",
  "U\xCC\x9B"                                        => "\xC6\xAF",
  "U\xCC\x9B\xCC\x80"                                => "\xE1\xBB\xAA",
  "U\xCC\x9B\xCC\x81"                                => "\xE1\xBB\xA8",
  "U\xCC\x9B\xCC\x83"                                => "\xE1\xBB\xAE",
  "U\xCC\x9B\xCC\x89"                                => "\xE1\xBB\xAC",
  "U\xCC\x9B\xCC\xA3"                                => "\xE1\xBB\xB0",
  "U\xCC\xA3"                                        => "\xE1\xBB\xA4",
  "U\xCC\xA4"                                        => "\xE1\xB9\xB2",
  "U\xCC\xA8"                                        => "\xC5\xB2",
  "U\xCC\xAD"                                        => "\xE1\xB9\xB6",
  "U\xCC\xB0"                                        => "\xE1\xB9\xB4",
  "V\xCC\x83"                                        => "\xE1\xB9\xBC",
  "V\xCC\xA3"                                        => "\xE1\xB9\xBE",
  "W\xCC\x80"                                        => "\xE1\xBA\x80",
  "W\xCC\x81"                                        => "\xE1\xBA\x82",
  "W\xCC\x82"                                        => "\xC5\xB4",
  "W\xCC\x87"                                        => "\xE1\xBA\x86",
  "W\xCC\x88"                                        => "\xE1\xBA\x84",
  "W\xCC\xA3"                                        => "\xE1\xBA\x88",
  "X\xCC\x87"                                        => "\xE1\xBA\x8A",
  "X\xCC\x88"                                        => "\xE1\xBA\x8C",
  "Y\xCC\x80"                                        => "\xE1\xBB\xB2",
  "Y\xCC\x81"                                        => "\xC3\x9D",
  "Y\xCC\x82"                                        => "\xC5\xB6",
  "Y\xCC\x83"                                        => "\xE1\xBB\xB8",
  "Y\xCC\x84"                                        => "\xC8\xB2",
  "Y\xCC\x87"                                        => "\xE1\xBA\x8E",
  "Y\xCC\x88"                                        => "\xC5\xB8",
  "Y\xCC\x89"                                        => "\xE1\xBB\xB6",
  "Y\xCC\xA3"                                        => "\xE1\xBB\xB4",
  "Z\xCC\x81"                                        => "\xC5\xB9",
  "Z\xCC\x82"                                        => "\xE1\xBA\x90",
  "Z\xCC\x87"                                        => "\xC5\xBB",
  "Z\xCC\x8C"                                        => "\xC5\xBD",
  "Z\xCC\xA3"                                        => "\xE1\xBA\x92",
  "Z\xCC\xB1"                                        => "\xE1\xBA\x94",
  "a\xCC\x80"                                        => "\xC3\xA0",
  "a\xCC\x81"                                        => "\xC3\xA1",
  "a\xCC\x82"                                        => "\xC3\xA2",
  "a\xCC\x82\xCC\x80"                                => "\xE1\xBA\xA7",
  "a\xCC\x82\xCC\x81"                                => "\xE1\xBA\xA5",
  "a\xCC\x82\xCC\x83"                                => "\xE1\xBA\xAB",
  "a\xCC\x82\xCC\x89"                                => "\xE1\xBA\xA9",
  "a\xCC\x83"                                        => "\xC3\xA3",
  "a\xCC\x84"                                        => "\xC4\x81",
  "a\xCC\x86"                                        => "\xC4\x83",
  "a\xCC\x86\xCC\x80"                                => "\xE1\xBA\xB1",
  "a\xCC\x86\xCC\x81"                                => "\xE1\xBA\xAF",
  "a\xCC\x86\xCC\x83"                                => "\xE1\xBA\xB5",
  "a\xCC\x86\xCC\x89"                                => "\xE1\xBA\xB3",
  "a\xCC\x87"                                        => "\xC8\xA7",
  "a\xCC\x87\xCC\x84"                                => "\xC7\xA1",
  "a\xCC\x88"                                        => "\xC3\xA4",
  "a\xCC\x88\xCC\x84"                                => "\xC7\x9F",
  "a\xCC\x89"                                        => "\xE1\xBA\xA3",
  "a\xCC\x8A"                                        => "\xC3\xA5",
  "a\xCC\x8A\xCC\x81"                                => "\xC7\xBB",
  "a\xCC\x8C"                                        => "\xC7\x8E",
  "a\xCC\x8F"                                        => "\xC8\x81",
  "a\xCC\x91"                                        => "\xC8\x83",
  "a\xCC\xA3"                                        => "\xE1\xBA\xA1",
  "a\xCC\xA3\xCC\x82"                                => "\xE1\xBA\xAD",
  "a\xCC\xA3\xCC\x86"                                => "\xE1\xBA\xB7",
  "a\xCC\xA5"                                        => "\xE1\xB8\x81",
  "a\xCC\xA8"                                        => "\xC4\x85",
  "b\xCC\x87"                                        => "\xE1\xB8\x83",
  "b\xCC\xA3"                                        => "\xE1\xB8\x85",
  "b\xCC\xB1"                                        => "\xE1\xB8\x87",
  "c\xCC\x81"                                        => "\xC4\x87",
  "c\xCC\x82"                                        => "\xC4\x89",
  "c\xCC\x87"                                        => "\xC4\x8B",
  "c\xCC\x8C"                                        => "\xC4\x8D",
  "c\xCC\xA7"                                        => "\xC3\xA7",
  "c\xCC\xA7\xCC\x81"                                => "\xE1\xB8\x89",
  "d\xCC\x87"                                        => "\xE1\xB8\x8B",
  "d\xCC\x8C"                                        => "\xC4\x8F",
  "d\xCC\xA3"                                        => "\xE1\xB8\x8D",
  "d\xCC\xA7"                                        => "\xE1\xB8\x91",
  "d\xCC\xAD"                                        => "\xE1\xB8\x93",
  "d\xCC\xB1"                                        => "\xE1\xB8\x8F",
  "e\xCC\x80"                                        => "\xC3\xA8",
  "e\xCC\x81"                                        => "\xC3\xA9",
  "e\xCC\x82"                                        => "\xC3\xAA",
  "e\xCC\x82\xCC\x80"                                => "\xE1\xBB\x81",
  "e\xCC\x82\xCC\x81"                                => "\xE1\xBA\xBF",
  "e\xCC\x82\xCC\x83"                                => "\xE1\xBB\x85",
  "e\xCC\x82\xCC\x89"                                => "\xE1\xBB\x83",
  "e\xCC\x83"                                        => "\xE1\xBA\xBD",
  "e\xCC\x84"                                        => "\xC4\x93",
  "e\xCC\x84\xCC\x80"                                => "\xE1\xB8\x95",
  "e\xCC\x84\xCC\x81"                                => "\xE1\xB8\x97",
  "e\xCC\x86"                                        => "\xC4\x95",
  "e\xCC\x87"                                        => "\xC4\x97",
  "e\xCC\x88"                                        => "\xC3\xAB",
  "e\xCC\x89"                                        => "\xE1\xBA\xBB",
  "e\xCC\x8C"                                        => "\xC4\x9B",
  "e\xCC\x8F"                                        => "\xC8\x85",
  "e\xCC\x91"                                        => "\xC8\x87",
  "e\xCC\xA3"                                        => "\xE1\xBA\xB9",
  "e\xCC\xA3\xCC\x82"                                => "\xE1\xBB\x87",
  "e\xCC\xA7"                                        => "\xC8\xA9",
  "e\xCC\xA7\xCC\x86"                                => "\xE1\xB8\x9D",
  "e\xCC\xA8"                                        => "\xC4\x99",
  "e\xCC\xAD"                                        => "\xE1\xB8\x99",
  "e\xCC\xB0"                                        => "\xE1\xB8\x9B",
  "f\xCC\x87"                                        => "\xE1\xB8\x9F",
  "g\xCC\x81"                                        => "\xC7\xB5",
  "g\xCC\x82"                                        => "\xC4\x9D",
  "g\xCC\x84"                                        => "\xE1\xB8\xA1",
  "g\xCC\x86"                                        => "\xC4\x9F",
  "g\xCC\x87"                                        => "\xC4\xA1",
  "g\xCC\x8C"                                        => "\xC7\xA7",
  "g\xCC\xA7"                                        => "\xC4\xA3",
  "h\xCC\x82"                                        => "\xC4\xA5",
  "h\xCC\x87"                                        => "\xE1\xB8\xA3",
  "h\xCC\x88"                                        => "\xE1\xB8\xA7",
  "h\xCC\x8C"                                        => "\xC8\x9F",
  "h\xCC\xA3"                                        => "\xE1\xB8\xA5",
  "h\xCC\xA7"                                        => "\xE1\xB8\xA9",
  "h\xCC\xAE"                                        => "\xE1\xB8\xAB",
  "h\xCC\xB1"                                        => "\xE1\xBA\x96",
  "i\xCC\x80"                                        => "\xC3\xAC",
  "i\xCC\x81"                                        => "\xC3\xAD",
  "i\xCC\x82"                                        => "\xC3\xAE",
  "i\xCC\x83"                                        => "\xC4\xA9",
  "i\xCC\x84"                                        => "\xC4\xAB",
  "i\xCC\x86"                                        => "\xC4\xAD",
  "i\xCC\x88"                                        => "\xC3\xAF",
  "i\xCC\x88\xCC\x81"                                => "\xE1\xB8\xAF",
  "i\xCC\x89"                                        => "\xE1\xBB\x89",
  "i\xCC\x8C"                                        => "\xC7\x90",
  "i\xCC\x8F"                                        => "\xC8\x89",
  "i\xCC\x91"                                        => "\xC8\x8B",
  "i\xCC\xA3"                                        => "\xE1\xBB\x8B",
  "i\xCC\xA8"                                        => "\xC4\xAF",
  "i\xCC\xB0"                                        => "\xE1\xB8\xAD",
  "j\xCC\x82"                                        => "\xC4\xB5",
  "j\xCC\x8C"                                        => "\xC7\xB0",
  "k\xCC\x81"                                        => "\xE1\xB8\xB1",
  "k\xCC\x8C"                                        => "\xC7\xA9",
  "k\xCC\xA3"                                        => "\xE1\xB8\xB3",
  "k\xCC\xA7"                                        => "\xC4\xB7",
  "k\xCC\xB1"                                        => "\xE1\xB8\xB5",
  "l\xCC\x81"                                        => "\xC4\xBA",
  "l\xCC\x8C"                                        => "\xC4\xBE",
  "l\xCC\xA3"                                        => "\xE1\xB8\xB7",
  "l\xCC\xA3\xCC\x84"                                => "\xE1\xB8\xB9",
  "l\xCC\xA7"                                        => "\xC4\xBC",
  "l\xCC\xAD"                                        => "\xE1\xB8\xBD",
  "l\xCC\xB1"                                        => "\xE1\xB8\xBB",
  "m\xCC\x81"                                        => "\xE1\xB8\xBF",
  "m\xCC\x87"                                        => "\xE1\xB9\x81",
  "m\xCC\xA3"                                        => "\xE1\xB9\x83",
  "n\xCC\x80"                                        => "\xC7\xB9",
  "n\xCC\x81"                                        => "\xC5\x84",
  "n\xCC\x83"                                        => "\xC3\xB1",
  "n\xCC\x87"                                        => "\xE1\xB9\x85",
  "n\xCC\x8C"                                        => "\xC5\x88",
  "n\xCC\xA3"                                        => "\xE1\xB9\x87",
  "n\xCC\xA7"                                        => "\xC5\x86",
  "n\xCC\xAD"                                        => "\xE1\xB9\x8B",
  "n\xCC\xB1"                                        => "\xE1\xB9\x89",
  "o\xCC\x80"                                        => "\xC3\xB2",
  "o\xCC\x81"                                        => "\xC3\xB3",
  "o\xCC\x82"                                        => "\xC3\xB4",
  "o\xCC\x82\xCC\x80"                                => "\xE1\xBB\x93",
  "o\xCC\x82\xCC\x81"                                => "\xE1\xBB\x91",
  "o\xCC\x82\xCC\x83"                                => "\xE1\xBB\x97",
  "o\xCC\x82\xCC\x89"                                => "\xE1\xBB\x95",
  "o\xCC\x83"                                        => "\xC3\xB5",
  "o\xCC\x83\xCC\x81"                                => "\xE1\xB9\x8D",
  "o\xCC\x83\xCC\x84"                                => "\xC8\xAD",
  "o\xCC\x83\xCC\x88"                                => "\xE1\xB9\x8F",
  "o\xCC\x84"                                        => "\xC5\x8D",
  "o\xCC\x84\xCC\x80"                                => "\xE1\xB9\x91",
  "o\xCC\x84\xCC\x81"                                => "\xE1\xB9\x93",
  "o\xCC\x86"                                        => "\xC5\x8F",
  "o\xCC\x87"                                        => "\xC8\xAF",
  "o\xCC\x87\xCC\x84"                                => "\xC8\xB1",
  "o\xCC\x88"                                        => "\xC3\xB6",
  "o\xCC\x88\xCC\x84"                                => "\xC8\xAB",
  "o\xCC\x89"                                        => "\xE1\xBB\x8F",
  "o\xCC\x8B"                                        => "\xC5\x91",
  "o\xCC\x8C"                                        => "\xC7\x92",
  "o\xCC\x8F"                                        => "\xC8\x8D",
  "o\xCC\x91"                                        => "\xC8\x8F",
  "o\xCC\x9B"                                        => "\xC6\xA1",
  "o\xCC\x9B\xCC\x80"                                => "\xE1\xBB\x9D",
  "o\xCC\x9B\xCC\x81"                                => "\xE1\xBB\x9B",
  "o\xCC\x9B\xCC\x83"                                => "\xE1\xBB\xA1",
  "o\xCC\x9B\xCC\x89"                                => "\xE1\xBB\x9F",
  "o\xCC\x9B\xCC\xA3"                                => "\xE1\xBB\xA3",
  "o\xCC\xA3"                                        => "\xE1\xBB\x8D",
  "o\xCC\xA3\xCC\x82"                                => "\xE1\xBB\x99",
  "o\xCC\xA8"                                        => "\xC7\xAB",
  "o\xCC\xA8\xCC\x84"                                => "\xC7\xAD",
  "p\xCC\x81"                                        => "\xE1\xB9\x95",
  "p\xCC\x87"                                        => "\xE1\xB9\x97",
  "r\xCC\x81"                                        => "\xC5\x95",
  "r\xCC\x87"                                        => "\xE1\xB9\x99",
  "r\xCC\x8C"                                        => "\xC5\x99",
  "r\xCC\x8F"                                        => "\xC8\x91",
  "r\xCC\x91"                                        => "\xC8\x93",
  "r\xCC\xA3"                                        => "\xE1\xB9\x9B",
  "r\xCC\xA3\xCC\x84"                                => "\xE1\xB9\x9D",
  "r\xCC\xA7"                                        => "\xC5\x97",
  "r\xCC\xB1"                                        => "\xE1\xB9\x9F",
  "s\xCC\x81"                                        => "\xC5\x9B",
  "s\xCC\x81\xCC\x87"                                => "\xE1\xB9\xA5",
  "s\xCC\x82"                                        => "\xC5\x9D",
  "s\xCC\x87"                                        => "\xE1\xB9\xA1",
  "s\xCC\x8C"                                        => "\xC5\xA1",
  "s\xCC\x8C\xCC\x87"                                => "\xE1\xB9\xA7",
  "s\xCC\xA3"                                        => "\xE1\xB9\xA3",
  "s\xCC\xA3\xCC\x87"                                => "\xE1\xB9\xA9",
  "s\xCC\xA6"                                        => "\xC8\x99",
  "s\xCC\xA7"                                        => "\xC5\x9F",
  "t\xCC\x87"                                        => "\xE1\xB9\xAB",
  "t\xCC\x88"                                        => "\xE1\xBA\x97",
  "t\xCC\x8C"                                        => "\xC5\xA5",
  "t\xCC\xA3"                                        => "\xE1\xB9\xAD",
  "t\xCC\xA6"                                        => "\xC8\x9B",
  "t\xCC\xA7"                                        => "\xC5\xA3",
  "t\xCC\xAD"                                        => "\xE1\xB9\xB1",
  "t\xCC\xB1"                                        => "\xE1\xB9\xAF",
  "u\xCC\x80"                                        => "\xC3\xB9",
  "u\xCC\x81"                                        => "\xC3\xBA",
  "u\xCC\x82"                                        => "\xC3\xBB",
  "u\xCC\x83"                                        => "\xC5\xA9",
  "u\xCC\x83\xCC\x81"                                => "\xE1\xB9\xB9",
  "u\xCC\x84"                                        => "\xC5\xAB",
  "u\xCC\x84\xCC\x88"                                => "\xE1\xB9\xBB",
  "u\xCC\x86"                                        => "\xC5\xAD",
  "u\xCC\x88"                                        => "\xC3\xBC",
  "u\xCC\x88\xCC\x80"                                => "\xC7\x9C",
  "u\xCC\x88\xCC\x81"                                => "\xC7\x98",
  "u\xCC\x88\xCC\x84"                                => "\xC7\x96",
  "u\xCC\x88\xCC\x8C"                                => "\xC7\x9A",
  "u\xCC\x89"                                        => "\xE1\xBB\xA7",
  "u\xCC\x8A"                                        => "\xC5\xAF",
  "u\xCC\x8B"                                        => "\xC5\xB1",
  "u\xCC\x8C"                                        => "\xC7\x94",
  "u\xCC\x8F"                                        => "\xC8\x95",
  "u\xCC\x91"                                        => "\xC8\x97",
  "u\xCC\x9B"                                        => "\xC6\xB0",
  "u\xCC\x9B\xCC\x80"                                => "\xE1\xBB\xAB",
  "u\xCC\x9B\xCC\x81"                                => "\xE1\xBB\xA9",
  "u\xCC\x9B\xCC\x83"                                => "\xE1\xBB\xAF",
  "u\xCC\x9B\xCC\x89"                                => "\xE1\xBB\xAD",
  "u\xCC\x9B\xCC\xA3"                                => "\xE1\xBB\xB1",
  "u\xCC\xA3"                                        => "\xE1\xBB\xA5",
  "u\xCC\xA4"                                        => "\xE1\xB9\xB3",
  "u\xCC\xA8"                                        => "\xC5\xB3",
  "u\xCC\xAD"                                        => "\xE1\xB9\xB7",
  "u\xCC\xB0"                                        => "\xE1\xB9\xB5",
  "v\xCC\x83"                                        => "\xE1\xB9\xBD",
  "v\xCC\xA3"                                        => "\xE1\xB9\xBF",
  "w\xCC\x80"                                        => "\xE1\xBA\x81",
  "w\xCC\x81"                                        => "\xE1\xBA\x83",
  "w\xCC\x82"                                        => "\xC5\xB5",
  "w\xCC\x87"                                        => "\xE1\xBA\x87",
  "w\xCC\x88"                                        => "\xE1\xBA\x85",
  "w\xCC\x8A"                                        => "\xE1\xBA\x98",
  "w\xCC\xA3"                                        => "\xE1\xBA\x89",
  "x\xCC\x87"                                        => "\xE1\xBA\x8B",
  "x\xCC\x88"                                        => "\xE1\xBA\x8D",
  "y\xCC\x80"                                        => "\xE1\xBB\xB3",
  "y\xCC\x81"                                        => "\xC3\xBD",
  "y\xCC\x82"                                        => "\xC5\xB7",
  "y\xCC\x83"                                        => "\xE1\xBB\xB9",
  "y\xCC\x84"                                        => "\xC8\xB3",
  "y\xCC\x87"                                        => "\xE1\xBA\x8F",
  "y\xCC\x88"                                        => "\xC3\xBF",
  "y\xCC\x89"                                        => "\xE1\xBB\xB7",
  "y\xCC\x8A"                                        => "\xE1\xBA\x99",
  "y\xCC\xA3"                                        => "\xE1\xBB\xB5",
  "z\xCC\x81"                                        => "\xC5\xBA",
  "z\xCC\x82"                                        => "\xE1\xBA\x91",
  "z\xCC\x87"                                        => "\xC5\xBC",
  "z\xCC\x8C"                                        => "\xC5\xBE",
  "z\xCC\xA3"                                        => "\xE1\xBA\x93",
  "z\xCC\xB1"                                        => "\xE1\xBA\x95",
  "\xC2\xB7"                                         => "\xCE\x87",
  "\xC3\x86\xCC\x81"                                 => "\xC7\xBC",
  "\xC3\x86\xCC\x84"                                 => "\xC7\xA2",
  "\xC3\x98\xCC\x81"                                 => "\xC7\xBE",
  "\xC3\xA6\xCC\x81"                                 => "\xC7\xBD",
  "\xC3\xA6\xCC\x84"                                 => "\xC7\xA3",
  "\xC3\xB8\xCC\x81"                                 => "\xC7\xBF",
  "\xC6\xB7\xCC\x8C"                                 => "\xC7\xAE",
  "\xCA\x92\xCC\x8C"                                 => "\xC7\xAF",
  "\xCA\xB9"                                         => "\xCD\xB4",
  "\xCC\x80"                                         => "\xCD\x80",
  "\xCC\x81"                                         => "\xCD\x81",
  "\xCC\x88\xCC\x81"                                 => "\xCD\x84",
  "\xCC\x93"                                         => "\xCD\x83",
  "\xCE\x91\xCC\x80"                                 => "\xE1\xBE\xBA",
  "\xCE\x91\xCC\x81"                                 => "\xCE\x86",
  "\xCE\x91\xCC\x84"                                 => "\xE1\xBE\xB9",
  "\xCE\x91\xCC\x86"                                 => "\xE1\xBE\xB8",
  "\xCE\x91\xCC\x93"                                 => "\xE1\xBC\x88",
  "\xCE\x91\xCC\x93\xCC\x80"                         => "\xE1\xBC\x8A",
  "\xCE\x91\xCC\x93\xCC\x80\xCD\x85"                 => "\xE1\xBE\x8A",
  "\xCE\x91\xCC\x93\xCC\x81"                         => "\xE1\xBC\x8C",
  "\xCE\x91\xCC\x93\xCC\x81\xCD\x85"                 => "\xE1\xBE\x8C",
  "\xCE\x91\xCC\x93\xCD\x82"                         => "\xE1\xBC\x8E",
  "\xCE\x91\xCC\x93\xCD\x82\xCD\x85"                 => "\xE1\xBE\x8E",
  "\xCE\x91\xCC\x93\xCD\x85"                         => "\xE1\xBE\x88",
  "\xCE\x91\xCC\x94"                                 => "\xE1\xBC\x89",
  "\xCE\x91\xCC\x94\xCC\x80"                         => "\xE1\xBC\x8B",
  "\xCE\x91\xCC\x94\xCC\x80\xCD\x85"                 => "\xE1\xBE\x8B",
  "\xCE\x91\xCC\x94\xCC\x81"                         => "\xE1\xBC\x8D",
  "\xCE\x91\xCC\x94\xCC\x81\xCD\x85"                 => "\xE1\xBE\x8D",
  "\xCE\x91\xCC\x94\xCD\x82"                         => "\xE1\xBC\x8F",
  "\xCE\x91\xCC\x94\xCD\x82\xCD\x85"                 => "\xE1\xBE\x8F",
  "\xCE\x91\xCC\x94\xCD\x85"                         => "\xE1\xBE\x89",
  "\xCE\x91\xCD\x85"                                 => "\xE1\xBE\xBC",
  "\xCE\x95\xCC\x80"                                 => "\xE1\xBF\x88",
  "\xCE\x95\xCC\x81"                                 => "\xE1\xBF\x89",
  "\xCE\x95\xCC\x93"                                 => "\xE1\xBC\x98",
  "\xCE\x95\xCC\x93\xCC\x80"                         => "\xE1\xBC\x9A",
  "\xCE\x95\xCC\x93\xCC\x81"                         => "\xE1\xBC\x9C",
  "\xCE\x95\xCC\x94"                                 => "\xE1\xBC\x99",
  "\xCE\x95\xCC\x94\xCC\x80"                         => "\xE1\xBC\x9B",
  "\xCE\x95\xCC\x94\xCC\x81"                         => "\xE1\xBC\x9D",
  "\xCE\x97\xCC\x80"                                 => "\xE1\xBF\x8A",
  "\xCE\x97\xCC\x81"                                 => "\xE1\xBF\x8B",
  "\xCE\x97\xCC\x93"                                 => "\xE1\xBC\xA8",
  "\xCE\x97\xCC\x93\xCC\x80"                         => "\xE1\xBC\xAA",
  "\xCE\x97\xCC\x93\xCC\x80\xCD\x85"                 => "\xE1\xBE\x9A",
  "\xCE\x97\xCC\x93\xCC\x81"                         => "\xE1\xBC\xAC",
  "\xCE\x97\xCC\x93\xCC\x81\xCD\x85"                 => "\xE1\xBE\x9C",
  "\xCE\x97\xCC\x93\xCD\x82"                         => "\xE1\xBC\xAE",
  "\xCE\x97\xCC\x93\xCD\x82\xCD\x85"                 => "\xE1\xBE\x9E",
  "\xCE\x97\xCC\x93\xCD\x85"                         => "\xE1\xBE\x98",
  "\xCE\x97\xCC\x94"                                 => "\xE1\xBC\xA9",
  "\xCE\x97\xCC\x94\xCC\x80"                         => "\xE1\xBC\xAB",
  "\xCE\x97\xCC\x94\xCC\x80\xCD\x85"                 => "\xE1\xBE\x9B",
  "\xCE\x97\xCC\x94\xCC\x81"                         => "\xE1\xBC\xAD",
  "\xCE\x97\xCC\x94\xCC\x81\xCD\x85"                 => "\xE1\xBE\x9D",
  "\xCE\x97\xCC\x94\xCD\x82"                         => "\xE1\xBC\xAF",
  "\xCE\x97\xCC\x94\xCD\x82\xCD\x85"                 => "\xE1\xBE\x9F",
  "\xCE\x97\xCC\x94\xCD\x85"                         => "\xE1\xBE\x99",
  "\xCE\x97\xCD\x85"                                 => "\xE1\xBF\x8C",
  "\xCE\x99\xCC\x80"                                 => "\xE1\xBF\x9A",
  "\xCE\x99\xCC\x81"                                 => "\xCE\x8A",
  "\xCE\x99\xCC\x84"                                 => "\xE1\xBF\x99",
  "\xCE\x99\xCC\x86"                                 => "\xE1\xBF\x98",
  "\xCE\x99\xCC\x88"                                 => "\xCE\xAA",
  "\xCE\x99\xCC\x93"                                 => "\xE1\xBC\xB8",
  "\xCE\x99\xCC\x93\xCC\x80"                         => "\xE1\xBC\xBA",
  "\xCE\x99\xCC\x93\xCC\x81"                         => "\xE1\xBC\xBC",
  "\xCE\x99\xCC\x93\xCD\x82"                         => "\xE1\xBC\xBE",
  "\xCE\x99\xCC\x94"                                 => "\xE1\xBC\xB9",
  "\xCE\x99\xCC\x94\xCC\x80"                         => "\xE1\xBC\xBB",
  "\xCE\x99\xCC\x94\xCC\x81"                         => "\xE1\xBC\xBD",
  "\xCE\x99\xCC\x94\xCD\x82"                         => "\xE1\xBC\xBF",
  "\xCE\x9F\xCC\x80"                                 => "\xE1\xBF\xB8",
  "\xCE\x9F\xCC\x81"                                 => "\xCE\x8C",
  "\xCE\x9F\xCC\x93"                                 => "\xE1\xBD\x88",
  "\xCE\x9F\xCC\x93\xCC\x80"                         => "\xE1\xBD\x8A",
  "\xCE\x9F\xCC\x93\xCC\x81"                         => "\xE1\xBD\x8C",
  "\xCE\x9F\xCC\x94"                                 => "\xE1\xBD\x89",
  "\xCE\x9F\xCC\x94\xCC\x80"                         => "\xE1\xBD\x8B",
  "\xCE\x9F\xCC\x94\xCC\x81"                         => "\xE1\xBD\x8D",
  "\xCE\xA1\xCC\x94"                                 => "\xE1\xBF\xAC",
  "\xCE\xA5\xCC\x80"                                 => "\xE1\xBF\xAA",
  "\xCE\xA5\xCC\x81"                                 => "\xE1\xBF\xAB",
  "\xCE\xA5\xCC\x84"                                 => "\xE1\xBF\xA9",
  "\xCE\xA5\xCC\x86"                                 => "\xE1\xBF\xA8",
  "\xCE\xA5\xCC\x88"                                 => "\xCE\xAB",
  "\xCE\xA5\xCC\x94"                                 => "\xE1\xBD\x99",
  "\xCE\xA5\xCC\x94\xCC\x80"                         => "\xE1\xBD\x9B",
  "\xCE\xA5\xCC\x94\xCC\x81"                         => "\xE1\xBD\x9D",
  "\xCE\xA5\xCC\x94\xCD\x82"                         => "\xE1\xBD\x9F",
  "\xCE\xA9"                                         => "\xE2\x84\xA6",
  "\xCE\xA9\xCC\x80"                                 => "\xE1\xBF\xBA",
  "\xCE\xA9\xCC\x81"                                 => "\xCE\x8F",
  "\xCE\xA9\xCC\x93"                                 => "\xE1\xBD\xA8",
  "\xCE\xA9\xCC\x93\xCC\x80"                         => "\xE1\xBD\xAA",
  "\xCE\xA9\xCC\x93\xCC\x80\xCD\x85"                 => "\xE1\xBE\xAA",
  "\xCE\xA9\xCC\x93\xCC\x81"                         => "\xE1\xBD\xAC",
  "\xCE\xA9\xCC\x93\xCC\x81\xCD\x85"                 => "\xE1\xBE\xAC",
  "\xCE\xA9\xCC\x93\xCD\x82"                         => "\xE1\xBD\xAE",
  "\xCE\xA9\xCC\x93\xCD\x82\xCD\x85"                 => "\xE1\xBE\xAE",
  "\xCE\xA9\xCC\x93\xCD\x85"                         => "\xE1\xBE\xA8",
  "\xCE\xA9\xCC\x94"                                 => "\xE1\xBD\xA9",
  "\xCE\xA9\xCC\x94\xCC\x80"                         => "\xE1\xBD\xAB",
  "\xCE\xA9\xCC\x94\xCC\x80\xCD\x85"                 => "\xE1\xBE\xAB",
  "\xCE\xA9\xCC\x94\xCC\x81"                         => "\xE1\xBD\xAD",
  "\xCE\xA9\xCC\x94\xCC\x81\xCD\x85"                 => "\xE1\xBE\xAD",
  "\xCE\xA9\xCC\x94\xCD\x82"                         => "\xE1\xBD\xAF",
  "\xCE\xA9\xCC\x94\xCD\x82\xCD\x85"                 => "\xE1\xBE\xAF",
  "\xCE\xA9\xCC\x94\xCD\x85"                         => "\xE1\xBE\xA9",
  "\xCE\xA9\xCD\x85"                                 => "\xE1\xBF\xBC",
  "\xCE\xB1\xCC\x80"                                 => "\xE1\xBD\xB0",
  "\xCE\xB1\xCC\x80\xCD\x85"                         => "\xE1\xBE\xB2",
  "\xCE\xB1\xCC\x81"                                 => "\xE1\xBD\xB1",
  "\xCE\xB1\xCC\x81\xCD\x85"                         => "\xE1\xBE\xB4",
  "\xCE\xB1\xCC\x84"                                 => "\xE1\xBE\xB1",
  "\xCE\xB1\xCC\x86"                                 => "\xE1\xBE\xB0",
  "\xCE\xB1\xCC\x93"                                 => "\xE1\xBC\x80",
  "\xCE\xB1\xCC\x93\xCC\x80"                         => "\xE1\xBC\x82",
  "\xCE\xB1\xCC\x93\xCC\x80\xCD\x85"                 => "\xE1\xBE\x82",
  "\xCE\xB1\xCC\x93\xCC\x81"                         => "\xE1\xBC\x84",
  "\xCE\xB1\xCC\x93\xCC\x81\xCD\x85"                 => "\xE1\xBE\x84",
  "\xCE\xB1\xCC\x93\xCD\x82"                         => "\xE1\xBC\x86",
  "\xCE\xB1\xCC\x93\xCD\x82\xCD\x85"                 => "\xE1\xBE\x86",
  "\xCE\xB1\xCC\x93\xCD\x85"                         => "\xE1\xBE\x80",
  "\xCE\xB1\xCC\x94"                                 => "\xE1\xBC\x81",
  "\xCE\xB1\xCC\x94\xCC\x80"                         => "\xE1\xBC\x83",
  "\xCE\xB1\xCC\x94\xCC\x80\xCD\x85"                 => "\xE1\xBE\x83",
  "\xCE\xB1\xCC\x94\xCC\x81"                         => "\xE1\xBC\x85",
  "\xCE\xB1\xCC\x94\xCC\x81\xCD\x85"                 => "\xE1\xBE\x85",
  "\xCE\xB1\xCC\x94\xCD\x82"                         => "\xE1\xBC\x87",
  "\xCE\xB1\xCC\x94\xCD\x82\xCD\x85"                 => "\xE1\xBE\x87",
  "\xCE\xB1\xCC\x94\xCD\x85"                         => "\xE1\xBE\x81",
  "\xCE\xB1\xCD\x82"                                 => "\xE1\xBE\xB6",
  "\xCE\xB1\xCD\x82\xCD\x85"                         => "\xE1\xBE\xB7",
  "\xCE\xB1\xCD\x85"                                 => "\xE1\xBE\xB3",
  "\xCE\xB5\xCC\x80"                                 => "\xE1\xBD\xB2",
  "\xCE\xB5\xCC\x81"                                 => "\xCE\xAD",
  "\xCE\xB5\xCC\x93"                                 => "\xE1\xBC\x90",
  "\xCE\xB5\xCC\x93\xCC\x80"                         => "\xE1\xBC\x92",
  "\xCE\xB5\xCC\x93\xCC\x81"                         => "\xE1\xBC\x94",
  "\xCE\xB5\xCC\x94"                                 => "\xE1\xBC\x91",
  "\xCE\xB5\xCC\x94\xCC\x80"                         => "\xE1\xBC\x93",
  "\xCE\xB5\xCC\x94\xCC\x81"                         => "\xE1\xBC\x95",
  "\xCE\xB7\xCC\x80"                                 => "\xE1\xBD\xB4",
  "\xCE\xB7\xCC\x80\xCD\x85"                         => "\xE1\xBF\x82",
  "\xCE\xB7\xCC\x81"                                 => "\xCE\xAE",
  "\xCE\xB7\xCC\x81\xCD\x85"                         => "\xE1\xBF\x84",
  "\xCE\xB7\xCC\x93"                                 => "\xE1\xBC\xA0",
  "\xCE\xB7\xCC\x93\xCC\x80"                         => "\xE1\xBC\xA2",
  "\xCE\xB7\xCC\x93\xCC\x80\xCD\x85"                 => "\xE1\xBE\x92",
  "\xCE\xB7\xCC\x93\xCC\x81"                         => "\xE1\xBC\xA4",
  "\xCE\xB7\xCC\x93\xCC\x81\xCD\x85"                 => "\xE1\xBE\x94",
  "\xCE\xB7\xCC\x93\xCD\x82"                         => "\xE1\xBC\xA6",
  "\xCE\xB7\xCC\x93\xCD\x82\xCD\x85"                 => "\xE1\xBE\x96",
  "\xCE\xB7\xCC\x93\xCD\x85"                         => "\xE1\xBE\x90",
  "\xCE\xB7\xCC\x94"                                 => "\xE1\xBC\xA1",
  "\xCE\xB7\xCC\x94\xCC\x80"                         => "\xE1\xBC\xA3",
  "\xCE\xB7\xCC\x94\xCC\x80\xCD\x85"                 => "\xE1\xBE\x93",
  "\xCE\xB7\xCC\x94\xCC\x81"                         => "\xE1\xBC\xA5",
  "\xCE\xB7\xCC\x94\xCC\x81\xCD\x85"                 => "\xE1\xBE\x95",
  "\xCE\xB7\xCC\x94\xCD\x82"                         => "\xE1\xBC\xA7",
  "\xCE\xB7\xCC\x94\xCD\x82\xCD\x85"                 => "\xE1\xBE\x97",
  "\xCE\xB7\xCC\x94\xCD\x85"                         => "\xE1\xBE\x91",
  "\xCE\xB7\xCD\x82"                                 => "\xE1\xBF\x86",
  "\xCE\xB7\xCD\x82\xCD\x85"                         => "\xE1\xBF\x87",
  "\xCE\xB7\xCD\x85"                                 => "\xE1\xBF\x83",
  "\xCE\xB9"                                         => "\xE1\xBE\xBE",
  "\xCE\xB9\xCC\x80"                                 => "\xE1\xBD\xB6",
  "\xCE\xB9\xCC\x81"                                 => "\xCE\xAF",
  "\xCE\xB9\xCC\x84"                                 => "\xE1\xBF\x91",
  "\xCE\xB9\xCC\x86"                                 => "\xE1\xBF\x90",
  "\xCE\xB9\xCC\x88"                                 => "\xCF\x8A",
  "\xCE\xB9\xCC\x88\xCC\x80"                         => "\xE1\xBF\x92",
  "\xCE\xB9\xCC\x88\xCC\x81"                         => "\xE1\xBF\x93",
  "\xCE\xB9\xCC\x88\xCD\x82"                         => "\xE1\xBF\x97",
  "\xCE\xB9\xCC\x93"                                 => "\xE1\xBC\xB0",
  "\xCE\xB9\xCC\x93\xCC\x80"                         => "\xE1\xBC\xB2",
  "\xCE\xB9\xCC\x93\xCC\x81"                         => "\xE1\xBC\xB4",
  "\xCE\xB9\xCC\x93\xCD\x82"                         => "\xE1\xBC\xB6",
  "\xCE\xB9\xCC\x94"                                 => "\xE1\xBC\xB1",
  "\xCE\xB9\xCC\x94\xCC\x80"                         => "\xE1\xBC\xB3",
  "\xCE\xB9\xCC\x94\xCC\x81"                         => "\xE1\xBC\xB5",
  "\xCE\xB9\xCC\x94\xCD\x82"                         => "\xE1\xBC\xB7",
  "\xCE\xB9\xCD\x82"                                 => "\xE1\xBF\x96",
  "\xCE\xBF\xCC\x80"                                 => "\xE1\xBD\xB8",
  "\xCE\xBF\xCC\x81"                                 => "\xCF\x8C",
  "\xCE\xBF\xCC\x93"                                 => "\xE1\xBD\x80",
  "\xCE\xBF\xCC\x93\xCC\x80"                         => "\xE1\xBD\x82",
  "\xCE\xBF\xCC\x93\xCC\x81"                         => "\xE1\xBD\x84",
  "\xCE\xBF\xCC\x94"                                 => "\xE1\xBD\x81",
  "\xCE\xBF\xCC\x94\xCC\x80"                         => "\xE1\xBD\x83",
  "\xCE\xBF\xCC\x94\xCC\x81"                         => "\xE1\xBD\x85",
  "\xCF\x81\xCC\x93"                                 => "\xE1\xBF\xA4",
  "\xCF\x81\xCC\x94"                                 => "\xE1\xBF\xA5",
  "\xCF\x85\xCC\x80"                                 => "\xE1\xBD\xBA",
  "\xCF\x85\xCC\x81"                                 => "\xE1\xBD\xBB",
  "\xCF\x85\xCC\x84"                                 => "\xE1\xBF\xA1",
  "\xCF\x85\xCC\x86"                                 => "\xE1\xBF\xA0",
  "\xCF\x85\xCC\x88"                                 => "\xCF\x8B",
  "\xCF\x85\xCC\x88\xCC\x80"                         => "\xE1\xBF\xA2",
  "\xCF\x85\xCC\x88\xCC\x81"                         => "\xCE\xB0",
  "\xCF\x85\xCC\x88\xCD\x82"                         => "\xE1\xBF\xA7",
  "\xCF\x85\xCC\x93"                                 => "\xE1\xBD\x90",
  "\xCF\x85\xCC\x93\xCC\x80"                         => "\xE1\xBD\x92",
  "\xCF\x85\xCC\x93\xCC\x81"                         => "\xE1\xBD\x94",
  "\xCF\x85\xCC\x93\xCD\x82"                         => "\xE1\xBD\x96",
  "\xCF\x85\xCC\x94"                                 => "\xE1\xBD\x91",
  "\xCF\x85\xCC\x94\xCC\x80"                         => "\xE1\xBD\x93",
  "\xCF\x85\xCC\x94\xCC\x81"                         => "\xE1\xBD\x95",
  "\xCF\x85\xCC\x94\xCD\x82"                         => "\xE1\xBD\x97",
  "\xCF\x85\xCD\x82"                                 => "\xE1\xBF\xA6",
  "\xCF\x89\xCC\x80"                                 => "\xE1\xBD\xBC",
  "\xCF\x89\xCC\x80\xCD\x85"                         => "\xE1\xBF\xB2",
  "\xCF\x89\xCC\x81"                                 => "\xCF\x8E",
  "\xCF\x89\xCC\x81\xCD\x85"                         => "\xE1\xBF\xB4",
  "\xCF\x89\xCC\x93"                                 => "\xE1\xBD\xA0",
  "\xCF\x89\xCC\x93\xCC\x80"                         => "\xE1\xBD\xA2",
  "\xCF\x89\xCC\x93\xCC\x80\xCD\x85"                 => "\xE1\xBE\xA2",
  "\xCF\x89\xCC\x93\xCC\x81"                         => "\xE1\xBD\xA4",
  "\xCF\x89\xCC\x93\xCC\x81\xCD\x85"                 => "\xE1\xBE\xA4",
  "\xCF\x89\xCC\x93\xCD\x82"                         => "\xE1\xBD\xA6",
  "\xCF\x89\xCC\x93\xCD\x82\xCD\x85"                 => "\xE1\xBE\xA6",
  "\xCF\x89\xCC\x93\xCD\x85"                         => "\xE1\xBE\xA0",
  "\xCF\x89\xCC\x94"                                 => "\xE1\xBD\xA1",
  "\xCF\x89\xCC\x94\xCC\x80"                         => "\xE1\xBD\xA3",
  "\xCF\x89\xCC\x94\xCC\x80\xCD\x85"                 => "\xE1\xBE\xA3",
  "\xCF\x89\xCC\x94\xCC\x81"                         => "\xE1\xBD\xA5",
  "\xCF\x89\xCC\x94\xCC\x81\xCD\x85"                 => "\xE1\xBE\xA5",
  "\xCF\x89\xCC\x94\xCD\x82"                         => "\xE1\xBD\xA7",
  "\xCF\x89\xCC\x94\xCD\x82\xCD\x85"                 => "\xE1\xBE\xA7",
  "\xCF\x89\xCC\x94\xCD\x85"                         => "\xE1\xBE\xA1",
  "\xCF\x89\xCD\x82"                                 => "\xE1\xBF\xB6",
  "\xCF\x89\xCD\x82\xCD\x85"                         => "\xE1\xBF\xB7",
  "\xCF\x89\xCD\x85"                                 => "\xE1\xBF\xB3",
  "\xD0\x86\xCC\x88"                                 => "\xD0\x87",
  "\xD0\x90\xCC\x86"                                 => "\xD3\x90",
  "\xD0\x90\xCC\x88"                                 => "\xD3\x92",
  "\xD0\x93\xCC\x81"                                 => "\xD0\x83",
  "\xD0\x95\xCC\x80"                                 => "\xD0\x80",
  "\xD0\x95\xCC\x86"                                 => "\xD3\x96",
  "\xD0\x95\xCC\x88"                                 => "\xD0\x81",
  "\xD0\x96\xCC\x86"                                 => "\xD3\x81",
  "\xD0\x96\xCC\x88"                                 => "\xD3\x9C",
  "\xD0\x97\xCC\x88"                                 => "\xD3\x9E",
  "\xD0\x98\xCC\x80"                                 => "\xD0\x8D",
  "\xD0\x98\xCC\x84"                                 => "\xD3\xA2",
  "\xD0\x98\xCC\x86"                                 => "\xD0\x99",
  "\xD0\x98\xCC\x88"                                 => "\xD3\xA4",
  "\xD0\x9A\xCC\x81"                                 => "\xD0\x8C",
  "\xD0\x9E\xCC\x88"                                 => "\xD3\xA6",
  "\xD0\xA3\xCC\x84"                                 => "\xD3\xAE",
  "\xD0\xA3\xCC\x86"                                 => "\xD0\x8E",
  "\xD0\xA3\xCC\x88"                                 => "\xD3\xB0",
  "\xD0\xA3\xCC\x8B"                                 => "\xD3\xB2",
  "\xD0\xA7\xCC\x88"                                 => "\xD3\xB4",
  "\xD0\xAB\xCC\x88"                                 => "\xD3\xB8",
  "\xD0\xAD\xCC\x88"                                 => "\xD3\xAC",
  "\xD0\xB0\xCC\x86"                                 => "\xD3\x91",
  "\xD0\xB0\xCC\x88"                                 => "\xD3\x93",
  "\xD0\xB3\xCC\x81"                                 => "\xD1\x93",
  "\xD0\xB5\xCC\x80"                                 => "\xD1\x90",
  "\xD0\xB5\xCC\x86"                                 => "\xD3\x97",
  "\xD0\xB5\xCC\x88"                                 => "\xD1\x91",
  "\xD0\xB6\xCC\x86"                                 => "\xD3\x82",
  "\xD0\xB6\xCC\x88"                                 => "\xD3\x9D",
  "\xD0\xB7\xCC\x88"                                 => "\xD3\x9F",
  "\xD0\xB8\xCC\x80"                                 => "\xD1\x9D",
  "\xD0\xB8\xCC\x84"                                 => "\xD3\xA3",
  "\xD0\xB8\xCC\x86"                                 => "\xD0\xB9",
  "\xD0\xB8\xCC\x88"                                 => "\xD3\xA5",
  "\xD0\xBA\xCC\x81"                                 => "\xD1\x9C",
  "\xD0\xBE\xCC\x88"                                 => "\xD3\xA7",
  "\xD1\x83\xCC\x84"                                 => "\xD3\xAF",
  "\xD1\x83\xCC\x86"                                 => "\xD1\x9E",
  "\xD1\x83\xCC\x88"                                 => "\xD3\xB1",
  "\xD1\x83\xCC\x8B"                                 => "\xD3\xB3",
  "\xD1\x87\xCC\x88"                                 => "\xD3\xB5",
  "\xD1\x8B\xCC\x88"                                 => "\xD3\xB9",
  "\xD1\x8D\xCC\x88"                                 => "\xD3\xAD",
  "\xD1\x96\xCC\x88"                                 => "\xD1\x97",
  "\xD1\xB4\xCC\x8F"                                 => "\xD1\xB6",
  "\xD1\xB5\xCC\x8F"                                 => "\xD1\xB7",
  "\xD3\x98\xCC\x88"                                 => "\xD3\x9A",
  "\xD3\x99\xCC\x88"                                 => "\xD3\x9B",
  "\xD3\xA8\xCC\x88"                                 => "\xD3\xAA",
  "\xD3\xA9\xCC\x88"                                 => "\xD3\xAB",
  "\xD7\x90\xD6\xB7"                                 => "\xEF\xAC\xAE",
  "\xD7\x90\xD6\xB8"                                 => "\xEF\xAC\xAF",
  "\xD7\x90\xD6\xBC"                                 => "\xEF\xAC\xB0",
  "\xD7\x91\xD6\xBC"                                 => "\xEF\xAC\xB1",
  "\xD7\x91\xD6\xBF"                                 => "\xEF\xAD\x8C",
  "\xD7\x92\xD6\xBC"                                 => "\xEF\xAC\xB2",
  "\xD7\x93\xD6\xBC"                                 => "\xEF\xAC\xB3",
  "\xD7\x94\xD6\xBC"                                 => "\xEF\xAC\xB4",
  "\xD7\x95\xD6\xB9"                                 => "\xEF\xAD\x8B",
  "\xD7\x95\xD6\xBC"                                 => "\xEF\xAC\xB5",
  "\xD7\x96\xD6\xBC"                                 => "\xEF\xAC\xB6",
  "\xD7\x98\xD6\xBC"                                 => "\xEF\xAC\xB8",
  "\xD7\x99\xD6\xB4"                                 => "\xEF\xAC\x9D",
  "\xD7\x99\xD6\xBC"                                 => "\xEF\xAC\xB9",
  "\xD7\x9A\xD6\xBC"                                 => "\xEF\xAC\xBA",
  "\xD7\x9B\xD6\xBC"                                 => "\xEF\xAC\xBB",
  "\xD7\x9B\xD6\xBF"                                 => "\xEF\xAD\x8D",
  "\xD7\x9C\xD6\xBC"                                 => "\xEF\xAC\xBC",
  "\xD7\x9E\xD6\xBC"                                 => "\xEF\xAC\xBE",
  "\xD7\xA0\xD6\xBC"                                 => "\xEF\xAD\x80",
  "\xD7\xA1\xD6\xBC"                                 => "\xEF\xAD\x81",
  "\xD7\xA3\xD6\xBC"                                 => "\xEF\xAD\x83",
  "\xD7\xA4\xD6\xBC"                                 => "\xEF\xAD\x84",
  "\xD7\xA4\xD6\xBF"                                 => "\xEF\xAD\x8E",
  "\xD7\xA6\xD6\xBC"                                 => "\xEF\xAD\x86",
  "\xD7\xA7\xD6\xBC"                                 => "\xEF\xAD\x87",
  "\xD7\xA8\xD6\xBC"                                 => "\xEF\xAD\x88",
  "\xD7\xA9\xD6\xBC"                                 => "\xEF\xAD\x89",
  "\xD7\xA9\xD6\xBC\xD7\x81"                         => "\xEF\xAC\xAC",
  "\xD7\xA9\xD6\xBC\xD7\x82"                         => "\xEF\xAC\xAD",
  "\xD7\xA9\xD7\x81"                                 => "\xEF\xAC\xAA",
  "\xD7\xA9\xD7\x82"                                 => "\xEF\xAC\xAB",
  "\xD7\xAA\xD6\xBC"                                 => "\xEF\xAD\x8A",
  "\xD7\xB2\xD6\xB7"                                 => "\xEF\xAC\x9F",
  "\xD8\xA7\xD9\x93"                                 => "\xD8\xA2",
  "\xD8\xA7\xD9\x94"                                 => "\xD8\xA3",
  "\xD8\xA7\xD9\x95"                                 => "\xD8\xA5",
  "\xD9\x88\xD9\x94"                                 => "\xD8\xA4",
  "\xD9\x8A\xD9\x94"                                 => "\xD8\xA6",
  "\xDB\x81\xD9\x94"                                 => "\xDB\x82",
  "\xDB\x92\xD9\x94"                                 => "\xDB\x93",
  "\xDB\x95\xD9\x94"                                 => "\xDB\x80",
  "\xE0\xA4\x95\xE0\xA4\xBC"                         => "\xE0\xA5\x98",
  "\xE0\xA4\x96\xE0\xA4\xBC"                         => "\xE0\xA5\x99",
  "\xE0\xA4\x97\xE0\xA4\xBC"                         => "\xE0\xA5\x9A",
  "\xE0\xA4\x9C\xE0\xA4\xBC"                         => "\xE0\xA5\x9B",
  "\xE0\xA4\xA1\xE0\xA4\xBC"                         => "\xE0\xA5\x9C",
  "\xE0\xA4\xA2\xE0\xA4\xBC"                         => "\xE0\xA5\x9D",
  "\xE0\xA4\xA8\xE0\xA4\xBC"                         => "\xE0\xA4\xA9",
  "\xE0\xA4\xAB\xE0\xA4\xBC"                         => "\xE0\xA5\x9E",
  "\xE0\xA4\xAF\xE0\xA4\xBC"                         => "\xE0\xA5\x9F",
  "\xE0\xA4\xB0\xE0\xA4\xBC"                         => "\xE0\xA4\xB1",
  "\xE0\xA4\xB3\xE0\xA4\xBC"                         => "\xE0\xA4\xB4",
  "\xE0\xA6\xA1\xE0\xA6\xBC"                         => "\xE0\xA7\x9C",
  "\xE0\xA6\xA2\xE0\xA6\xBC"                         => "\xE0\xA7\x9D",
  "\xE0\xA6\xAF\xE0\xA6\xBC"                         => "\xE0\xA7\x9F",
  "\xE0\xA7\x87\xE0\xA6\xBE"                         => "\xE0\xA7\x8B",
  "\xE0\xA7\x87\xE0\xA7\x97"                         => "\xE0\xA7\x8C",
  "\xE0\xA8\x96\xE0\xA8\xBC"                         => "\xE0\xA9\x99",
  "\xE0\xA8\x97\xE0\xA8\xBC"                         => "\xE0\xA9\x9A",
  "\xE0\xA8\x9C\xE0\xA8\xBC"                         => "\xE0\xA9\x9B",
  "\xE0\xA8\xAB\xE0\xA8\xBC"                         => "\xE0\xA9\x9E",
  "\xE0\xA8\xB2\xE0\xA8\xBC"                         => "\xE0\xA8\xB3",
  "\xE0\xA8\xB8\xE0\xA8\xBC"                         => "\xE0\xA8\xB6",
  "\xE0\xAC\xA1\xE0\xAC\xBC"                         => "\xE0\xAD\x9C",
  "\xE0\xAC\xA2\xE0\xAC\xBC"                         => "\xE0\xAD\x9D",
  "\xE0\xAD\x87\xE0\xAC\xBE"                         => "\xE0\xAD\x8B",
  "\xE0\xAD\x87\xE0\xAD\x96"                         => "\xE0\xAD\x88",
  "\xE0\xAD\x87\xE0\xAD\x97"                         => "\xE0\xAD\x8C",
  "\xE0\xAE\x92\xE0\xAF\x97"                         => "\xE0\xAE\x94",
  "\xE0\xAF\x86\xE0\xAE\xBE"                         => "\xE0\xAF\x8A",
  "\xE0\xAF\x86\xE0\xAF\x97"                         => "\xE0\xAF\x8C",
  "\xE0\xAF\x87\xE0\xAE\xBE"                         => "\xE0\xAF\x8B",
  "\xE0\xB1\x86\xE0\xB1\x96"                         => "\xE0\xB1\x88",
  "\xE0\xB2\xBF\xE0\xB3\x95"                         => "\xE0\xB3\x80",
  "\xE0\xB3\x86\xE0\xB3\x82"                         => "\xE0\xB3\x8A",
  "\xE0\xB3\x86\xE0\xB3\x82\xE0\xB3\x95"             => "\xE0\xB3\x8B",
  "\xE0\xB3\x86\xE0\xB3\x95"                         => "\xE0\xB3\x87",
  "\xE0\xB3\x86\xE0\xB3\x96"                         => "\xE0\xB3\x88",
  "\xE0\xB5\x86\xE0\xB4\xBE"                         => "\xE0\xB5\x8A",
  "\xE0\xB5\x86\xE0\xB5\x97"                         => "\xE0\xB5\x8C",
  "\xE0\xB5\x87\xE0\xB4\xBE"                         => "\xE0\xB5\x8B",
  "\xE0\xB7\x99\xE0\xB7\x8A"                         => "\xE0\xB7\x9A",
  "\xE0\xB7\x99\xE0\xB7\x8F"                         => "\xE0\xB7\x9C",
  "\xE0\xB7\x99\xE0\xB7\x8F\xE0\xB7\x8A"             => "\xE0\xB7\x9D",
  "\xE0\xB7\x99\xE0\xB7\x9F"                         => "\xE0\xB7\x9E",
  "\xE0\xBD\x80\xE0\xBE\xB5"                         => "\xE0\xBD\xA9",
  "\xE0\xBD\x82\xE0\xBE\xB7"                         => "\xE0\xBD\x83",
  "\xE0\xBD\x8C\xE0\xBE\xB7"                         => "\xE0\xBD\x8D",
  "\xE0\xBD\x91\xE0\xBE\xB7"                         => "\xE0\xBD\x92",
  "\xE0\xBD\x96\xE0\xBE\xB7"                         => "\xE0\xBD\x97",
  "\xE0\xBD\x9B\xE0\xBE\xB7"                         => "\xE0\xBD\x9C",
  "\xE0\xBD\xB1\xE0\xBD\xB2"                         => "\xE0\xBD\xB3",
  "\xE0\xBD\xB1\xE0\xBD\xB4"                         => "\xE0\xBD\xB5",
  "\xE0\xBD\xB1\xE0\xBE\x80"                         => "\xE0\xBE\x81",
  "\xE0\xBE\x90\xE0\xBE\xB5"                         => "\xE0\xBE\xB9",
  "\xE0\xBE\x92\xE0\xBE\xB7"                         => "\xE0\xBE\x93",
  "\xE0\xBE\x9C\xE0\xBE\xB7"                         => "\xE0\xBE\x9D",
  "\xE0\xBE\xA1\xE0\xBE\xB7"                         => "\xE0\xBE\xA2",
  "\xE0\xBE\xA6\xE0\xBE\xB7"                         => "\xE0\xBE\xA7",
  "\xE0\xBE\xAB\xE0\xBE\xB7"                         => "\xE0\xBE\xAC",
  "\xE0\xBE\xB2\xE0\xBE\x80"                         => "\xE0\xBD\xB6",
  "\xE0\xBE\xB3\xE0\xBE\x80"                         => "\xE0\xBD\xB8",
  "\xE1\x80\xA5\xE1\x80\xAE"                         => "\xE1\x80\xA6",
  "\xE1\xAC\x85\xE1\xAC\xB5"                         => "\xE1\xAC\x86",
  "\xE1\xAC\x87\xE1\xAC\xB5"                         => "\xE1\xAC\x88",
  "\xE1\xAC\x89\xE1\xAC\xB5"                         => "\xE1\xAC\x8A",
  "\xE1\xAC\x8B\xE1\xAC\xB5"                         => "\xE1\xAC\x8C",
  "\xE1\xAC\x8D\xE1\xAC\xB5"                         => "\xE1\xAC\x8E",
  "\xE1\xAC\x91\xE1\xAC\xB5"                         => "\xE1\xAC\x92",
  "\xE1\xAC\xBA\xE1\xAC\xB5"                         => "\xE1\xAC\xBB",
  "\xE1\xAC\xBC\xE1\xAC\xB5"                         => "\xE1\xAC\xBD",
  "\xE1\xAC\xBE\xE1\xAC\xB5"                         => "\xE1\xAD\x80",
  "\xE1\xAC\xBF\xE1\xAC\xB5"                         => "\xE1\xAD\x81",
  "\xE1\xAD\x82\xE1\xAC\xB5"                         => "\xE1\xAD\x83",
  "\xE2\x80\x83"                                     => "\xE2\x80\x81",
  "\xE2\x86\x90\xCC\xB8"                             => "\xE2\x86\x9A",
  "\xE2\x86\x92\xCC\xB8"                             => "\xE2\x86\x9B",
  "\xE2\x86\x94\xCC\xB8"                             => "\xE2\x86\xAE",
  "\xE2\x87\x90\xCC\xB8"                             => "\xE2\x87\x8D",
  "\xE2\x87\x92\xCC\xB8"                             => "\xE2\x87\x8F",
  "\xE2\x87\x94\xCC\xB8"                             => "\xE2\x87\x8E",
  "\xE2\x88\x83\xCC\xB8"                             => "\xE2\x88\x84",
  "\xE2\x88\x88\xCC\xB8"                             => "\xE2\x88\x89",
  "\xE2\x88\x8B\xCC\xB8"                             => "\xE2\x88\x8C",
  "\xE2\x88\xA3\xCC\xB8"                             => "\xE2\x88\xA4",
  "\xE2\x88\xA5\xCC\xB8"                             => "\xE2\x88\xA6",
  "\xE2\x88\xBC\xCC\xB8"                             => "\xE2\x89\x81",
  "\xE2\x89\x83\xCC\xB8"                             => "\xE2\x89\x84",
  "\xE2\x89\x85\xCC\xB8"                             => "\xE2\x89\x87",
  "\xE2\x89\x88\xCC\xB8"                             => "\xE2\x89\x89",
  "\xE2\x89\x8D\xCC\xB8"                             => "\xE2\x89\xAD",
  "\xE2\x89\xA1\xCC\xB8"                             => "\xE2\x89\xA2",
  "\xE2\x89\xA4\xCC\xB8"                             => "\xE2\x89\xB0",
  "\xE2\x89\xA5\xCC\xB8"                             => "\xE2\x89\xB1",
  "\xE2\x89\xB2\xCC\xB8"                             => "\xE2\x89\xB4",
  "\xE2\x89\xB3\xCC\xB8"                             => "\xE2\x89\xB5",
  "\xE2\x89\xB6\xCC\xB8"                             => "\xE2\x89\xB8",
  "\xE2\x89\xB7\xCC\xB8"                             => "\xE2\x89\xB9",
  "\xE2\x89\xBA\xCC\xB8"                             => "\xE2\x8A\x80",
  "\xE2\x89\xBB\xCC\xB8"                             => "\xE2\x8A\x81",
  "\xE2\x89\xBC\xCC\xB8"                             => "\xE2\x8B\xA0",
  "\xE2\x89\xBD\xCC\xB8"                             => "\xE2\x8B\xA1",
  "\xE2\x8A\x82\xCC\xB8"                             => "\xE2\x8A\x84",
  "\xE2\x8A\x83\xCC\xB8"                             => "\xE2\x8A\x85",
  "\xE2\x8A\x86\xCC\xB8"                             => "\xE2\x8A\x88",
  "\xE2\x8A\x87\xCC\xB8"                             => "\xE2\x8A\x89",
  "\xE2\x8A\x91\xCC\xB8"                             => "\xE2\x8B\xA2",
  "\xE2\x8A\x92\xCC\xB8"                             => "\xE2\x8B\xA3",
  "\xE2\x8A\xA2\xCC\xB8"                             => "\xE2\x8A\xAC",
  "\xE2\x8A\xA8\xCC\xB8"                             => "\xE2\x8A\xAD",
  "\xE2\x8A\xA9\xCC\xB8"                             => "\xE2\x8A\xAE",
  "\xE2\x8A\xAB\xCC\xB8"                             => "\xE2\x8A\xAF",
  "\xE2\x8A\xB2\xCC\xB8"                             => "\xE2\x8B\xAA",
  "\xE2\x8A\xB3\xCC\xB8"                             => "\xE2\x8B\xAB",
  "\xE2\x8A\xB4\xCC\xB8"                             => "\xE2\x8B\xAC",
  "\xE2\x8A\xB5\xCC\xB8"                             => "\xE2\x8B\xAD",
  "\xE2\xAB\x9D\xCC\xB8"                             => "\xE2\xAB\x9C",
  "\xE3\x80\x88"                                     => "\xE2\x8C\xA9",
  "\xE3\x80\x89"                                     => "\xE2\x8C\xAA",
  "\xE3\x81\x86\xE3\x82\x99"                         => "\xE3\x82\x94",
  "\xE3\x81\x8B\xE3\x82\x99"                         => "\xE3\x81\x8C",
  "\xE3\x81\x8D\xE3\x82\x99"                         => "\xE3\x81\x8E",
  "\xE3\x81\x8F\xE3\x82\x99"                         => "\xE3\x81\x90",
  "\xE3\x81\x91\xE3\x82\x99"                         => "\xE3\x81\x92",
  "\xE3\x81\x93\xE3\x82\x99"                         => "\xE3\x81\x94",
  "\xE3\x81\x95\xE3\x82\x99"                         => "\xE3\x81\x96",
  "\xE3\x81\x97\xE3\x82\x99"                         => "\xE3\x81\x98",
  "\xE3\x81\x99\xE3\x82\x99"                         => "\xE3\x81\x9A",
  "\xE3\x81\x9B\xE3\x82\x99"                         => "\xE3\x81\x9C",
  "\xE3\x81\x9D\xE3\x82\x99"                         => "\xE3\x81\x9E",
  "\xE3\x81\x9F\xE3\x82\x99"                         => "\xE3\x81\xA0",
  "\xE3\x81\xA1\xE3\x82\x99"                         => "\xE3\x81\xA2",
  "\xE3\x81\xA4\xE3\x82\x99"                         => "\xE3\x81\xA5",
  "\xE3\x81\xA6\xE3\x82\x99"                         => "\xE3\x81\xA7",
  "\xE3\x81\xA8\xE3\x82\x99"                         => "\xE3\x81\xA9",
  "\xE3\x81\xAF\xE3\x82\x99"                         => "\xE3\x81\xB0",
  "\xE3\x81\xAF\xE3\x82\x9A"                         => "\xE3\x81\xB1",
  "\xE3\x81\xB2\xE3\x82\x99"                         => "\xE3\x81\xB3",
  "\xE3\x81\xB2\xE3\x82\x9A"                         => "\xE3\x81\xB4",
  "\xE3\x81\xB5\xE3\x82\x99"                         => "\xE3\x81\xB6",
  "\xE3\x81\xB5\xE3\x82\x9A"                         => "\xE3\x81\xB7",
  "\xE3\x81\xB8\xE3\x82\x99"                         => "\xE3\x81\xB9",
  "\xE3\x81\xB8\xE3\x82\x9A"                         => "\xE3\x81\xBA",
  "\xE3\x81\xBB\xE3\x82\x99"                         => "\xE3\x81\xBC",
  "\xE3\x81\xBB\xE3\x82\x9A"                         => "\xE3\x81\xBD",
  "\xE3\x82\x9D\xE3\x82\x99"                         => "\xE3\x82\x9E",
  "\xE3\x82\xA6\xE3\x82\x99"                         => "\xE3\x83\xB4",
  "\xE3\x82\xAB\xE3\x82\x99"                         => "\xE3\x82\xAC",
  "\xE3\x82\xAD\xE3\x82\x99"                         => "\xE3\x82\xAE",
  "\xE3\x82\xAF\xE3\x82\x99"                         => "\xE3\x82\xB0",
  "\xE3\x82\xB1\xE3\x82\x99"                         => "\xE3\x82\xB2",
  "\xE3\x82\xB3\xE3\x82\x99"                         => "\xE3\x82\xB4",
  "\xE3\x82\xB5\xE3\x82\x99"                         => "\xE3\x82\xB6",
  "\xE3\x82\xB7\xE3\x82\x99"                         => "\xE3\x82\xB8",
  "\xE3\x82\xB9\xE3\x82\x99"                         => "\xE3\x82\xBA",
  "\xE3\x82\xBB\xE3\x82\x99"                         => "\xE3\x82\xBC",
  "\xE3\x82\xBD\xE3\x82\x99"                         => "\xE3\x82\xBE",
  "\xE3\x82\xBF\xE3\x82\x99"                         => "\xE3\x83\x80",
  "\xE3\x83\x81\xE3\x82\x99"                         => "\xE3\x83\x82",
  "\xE3\x83\x84\xE3\x82\x99"                         => "\xE3\x83\x85",
  "\xE3\x83\x86\xE3\x82\x99"                         => "\xE3\x83\x87",
  "\xE3\x83\x88\xE3\x82\x99"                         => "\xE3\x83\x89",
  "\xE3\x83\x8F\xE3\x82\x99"                         => "\xE3\x83\x90",
  "\xE3\x83\x8F\xE3\x82\x9A"                         => "\xE3\x83\x91",
  "\xE3\x83\x92\xE3\x82\x99"                         => "\xE3\x83\x93",
  "\xE3\x83\x92\xE3\x82\x9A"                         => "\xE3\x83\x94",
  "\xE3\x83\x95\xE3\x82\x99"                         => "\xE3\x83\x96",
  "\xE3\x83\x95\xE3\x82\x9A"                         => "\xE3\x83\x97",
  "\xE3\x83\x98\xE3\x82\x99"                         => "\xE3\x83\x99",
  "\xE3\x83\x98\xE3\x82\x9A"                         => "\xE3\x83\x9A",
  "\xE3\x83\x9B\xE3\x82\x99"                         => "\xE3\x83\x9C",
  "\xE3\x83\x9B\xE3\x82\x9A"                         => "\xE3\x83\x9D",
  "\xE3\x83\xAF\xE3\x82\x99"                         => "\xE3\x83\xB7",
  "\xE3\x83\xB0\xE3\x82\x99"                         => "\xE3\x83\xB8",
  "\xE3\x83\xB1\xE3\x82\x99"                         => "\xE3\x83\xB9",
  "\xE3\x83\xB2\xE3\x82\x99"                         => "\xE3\x83\xBA",
  "\xE3\x83\xBD\xE3\x82\x99"                         => "\xE3\x83\xBE",
  "\xE3\x92\x9E"                                     => "\xF0\xAF\xA0\x8C",
  "\xE3\x92\xB9"                                     => "\xF0\xAF\xA0\x93",
  "\xE3\x92\xBB"                                     => "\xF0\xAF\xA7\x8A",
  "\xE3\x93\x9F"                                     => "\xF0\xAF\xA0\x9F",
  "\xE3\x94\x95"                                     => "\xF0\xAF\xA0\xA4",
  "\xE3\x9B\xAE"                                     => "\xF0\xAF\xA1\xA7",
  "\xE3\x9B\xBC"                                     => "\xF0\xAF\xA1\xA8",
  "\xE3\x9E\x81"                                     => "\xF0\xAF\xA1\xB6",
  "\xE3\xA0\xAF"                                     => "\xF0\xAF\xA2\x83",
  "\xE3\xA1\xA2"                                     => "\xF0\xAF\xA2\x88",
  "\xE3\xA1\xBC"                                     => "\xF0\xAF\xA2\x8A",
  "\xE3\xA3\x87"                                     => "\xF0\xAF\xA2\x96",
  "\xE3\xA3\xA3"                                     => "\xF0\xAF\xA2\x9B",
  "\xE3\xA4\x9C"                                     => "\xF0\xAF\xA2\xA2",
  "\xE3\xA4\xBA"                                     => "\xF0\xAF\xA2\xA1",
  "\xE3\xA8\xAE"                                     => "\xF0\xAF\xA3\x82",
  "\xE3\xA9\xAC"                                     => "\xF0\xAF\xA3\x87",
  "\xE3\xAB\xA4"                                     => "\xF0\xAF\xA3\x91",
  "\xE3\xAC\x88"                                     => "\xF0\xAF\xA3\x90",
  "\xE3\xAC\x99"                                     => "\xF0\xAF\xA3\x8E",
  "\xE3\xAD\x89"                                     => "\xF0\xAF\xA3\x9E",
  "\xE3\xAE\x9D"                                     => "\xF0\xAF\xA3\xA7",
  "\xE3\xB0\x98"                                     => "\xF0\xAF\xA3\xAE",
  "\xE3\xB1\x8E"                                     => "\xF0\xAF\xA3\xB2",
  "\xE3\xB4\xB3"                                     => "\xF0\xAF\xA4\x8A",
  "\xE3\xB6\x96"                                     => "\xF0\xAF\xA4\x96",
  "\xE3\xBA\xAC"                                     => "\xF0\xAF\xA4\xAA",
  "\xE3\xBC\x9B"                                     => "\xF0\xAF\xA4\xB3",
  "\xE3\xBF\xBC"                                     => "\xF0\xAF\xA4\xBE",
  "\xE4\x80\x88"                                     => "\xF0\xAF\xA4\xBF",
  "\xE4\x80\x98"                                     => "\xEF\xAB\x93",
  "\xE4\x80\xB9"                                     => "\xF0\xAF\xA5\x89",
  "\xE4\x81\x86"                                     => "\xF0\xAF\xA5\x8B",
  "\xE4\x82\x96"                                     => "\xF0\xAF\xA5\x8C",
  "\xE4\x83\xA3"                                     => "\xF0\xAF\xA5\x91",
  "\xE4\x84\xAF"                                     => "\xF0\xAF\xA5\x98",
  "\xE4\x88\x82"                                     => "\xF0\xAF\xA5\xA0",
  "\xE4\x88\xA7"                                     => "\xF0\xAF\xA5\xA4",
  "\xE4\x8A\xA0"                                     => "\xF0\xAF\xA5\xA7",
  "\xE4\x8C\x81"                                     => "\xF0\xAF\xA5\xAD",
  "\xE4\x8C\xB4"                                     => "\xF0\xAF\xA5\xB1",
  "\xE4\x8D\x99"                                     => "\xF0\xAF\xA5\xB4",
  "\xE4\x8F\x95"                                     => "\xF0\xAF\xA6\x81",
  "\xE4\x8F\x99"                                     => "\xF0\xAF\xA3\x97",
  "\xE4\x90\x8B"                                     => "\xF0\xAF\xA6\x84",
  "\xE4\x91\xAB"                                     => "\xF0\xAF\xA6\x8E",
  "\xE4\x94\xAB"                                     => "\xF0\xAF\xA6\xA7",
  "\xE4\x95\x9D"                                     => "\xF0\xAF\xA6\xAE",
  "\xE4\x95\xA1"                                     => "\xF0\xAF\xA6\xAF",
  "\xE4\x95\xAB"                                     => "\xF0\xAF\xA6\xB2",
  "\xE4\x97\x97"                                     => "\xF0\xAF\xA6\xBF",
  "\xE4\x97\xB9"                                     => "\xF0\xAF\xA7\x82",
  "\xE4\x98\xB5"                                     => "\xF0\xAF\xA7\x88",
  "\xE4\x9A\xBE"                                     => "\xF0\xAF\xA7\x8D",
  "\xE4\x9B\x87"                                     => "\xF0\xAF\xA7\x8E",
  "\xE4\xA6\x95"                                     => "\xF0\xAF\xA7\xAF",
  "\xE4\xA7\xA6"                                     => "\xF0\xAF\xA7\xB2",
  "\xE4\xA9\xAE"                                     => "\xF0\xAF\xA7\xB8",
  "\xE4\xA9\xB6"                                     => "\xF0\xAF\xA7\xB9",
  "\xE4\xAA\xB2"                                     => "\xF0\xAF\xA7\xBC",
  "\xE4\xAC\xB3"                                     => "\xF0\xAF\xA8\x83",
  "\xE4\xAF\x8E"                                     => "\xF0\xAF\xA8\x88",
  "\xE4\xB3\x8E"                                     => "\xF0\xAF\xA8\x8D",
  "\xE4\xB3\xAD"                                     => "\xF0\xAF\xA8\x8E",
  "\xE4\xB3\xB8"                                     => "\xF0\xAF\xA8\x91",
  "\xE4\xB5\x96"                                     => "\xF0\xAF\xA8\x96",
  "\xE4\xB8\x8D"                                     => "\xEF\xA5\xA7",
  "\xE4\xB8\xA6"                                     => "\xEF\xA9\xB0",
  "\xE4\xB8\xB2"                                     => "\xEF\xA4\x85",
  "\xE4\xB8\xB8"                                     => "\xF0\xAF\xA0\x81",
  "\xE4\xB8\xB9"                                     => "\xEF\xA5\x9E",
  "\xE4\xB8\xBD"                                     => "\xF0\xAF\xA0\x80",
  "\xE4\xB9\x81"                                     => "\xF0\xAF\xA0\x82",
  "\xE4\xBA\x82"                                     => "\xEF\xA4\x9B",
  "\xE4\xBA\x86"                                     => "\xEF\xA6\xBA",
  "\xE4\xBA\xAE"                                     => "\xEF\xA5\xB7",
  "\xE4\xBB\x80"                                     => "\xEF\xA7\xBD",
  "\xE4\xBB\x8C"                                     => "\xF0\xAF\xA0\x99",
  "\xE4\xBB\xA4"                                     => "\xEF\xA6\xA8",
  "\xE4\xBD\xA0"                                     => "\xF0\xAF\xA0\x84",
  "\xE4\xBE\x80"                                     => "\xEF\xA9\xB3",
  "\xE4\xBE\x86"                                     => "\xEF\xA4\xAD",
  "\xE4\xBE\x8B"                                     => "\xEF\xA6\xB5",
  "\xE4\xBE\xAE"                                     => "\xF0\xAF\xA0\x85",
  "\xE4\xBE\xBB"                                     => "\xF0\xAF\xA0\x86",
  "\xE4\xBE\xBF"                                     => "\xEF\xA5\xA5",
  "\xE5\x80\x82"                                     => "\xF0\xAF\xA0\x87",
  "\xE5\x80\xAB"                                     => "\xEF\xA7\x94",
  "\xE5\x81\xBA"                                     => "\xF0\xAF\xA0\x88",
  "\xE5\x82\x99"                                     => "\xF0\xAF\xA0\x89",
  "\xE5\x83\x8F"                                     => "\xF0\xAF\xA0\x8B",
  "\xE5\x83\x9A"                                     => "\xEF\xA6\xBB",
  "\xE5\x83\xA7"                                     => "\xEF\xA8\xB1",
  "\xE5\x85\x80"                                     => "\xEF\xA8\x8C",
  "\xE5\x85\x85"                                     => "\xEF\xA9\xB4",
  "\xE5\x85\x8D"                                     => "\xF0\xAF\xA0\x8E",
  "\xE5\x85\x94"                                     => "\xF0\xAF\xA0\x8F",
  "\xE5\x85\xA4"                                     => "\xF0\xAF\xA0\x90",
  "\xE5\x85\xA7"                                     => "\xF0\xAF\xA0\x94",
  "\xE5\x85\xA8"                                     => "\xEF\xA9\xB2",
  "\xE5\x85\xA9"                                     => "\xEF\xA5\xB8",
  "\xE5\x85\xAD"                                     => "\xEF\xA7\x91",
  "\xE5\x85\xB7"                                     => "\xF0\xAF\xA0\x91",
  "\xE5\x86\x80"                                     => "\xEF\xA9\xB5",
  "\xE5\x86\x8D"                                     => "\xF0\xAF\xA0\x95",
  "\xE5\x86\x92"                                     => "\xF0\xAF\xA3\x92",
  "\xE5\x86\x95"                                     => "\xF0\xAF\xA3\x93",
  "\xE5\x86\x97"                                     => "\xF0\xAF\xA0\x97",
  "\xE5\x86\xA4"                                     => "\xF0\xAF\xA0\x98",
  "\xE5\x86\xAC"                                     => "\xF0\xAF\xA0\x9A",
  "\xE5\x86\xB5"                                     => "\xEF\xA9\xB1",
  "\xE5\x86\xB7"                                     => "\xEF\xA4\xAE",
  "\xE5\x87\x89"                                     => "\xEF\xA5\xB9",
  "\xE5\x87\x8C"                                     => "\xEF\xA5\x95",
  "\xE5\x87\x9C"                                     => "\xEF\xA5\x94",
  "\xE5\x87\x9E"                                     => "\xEF\xA8\x95",
  "\xE5\x87\xB5"                                     => "\xF0\xAF\xA0\x9D",
  "\xE5\x88\x83"                                     => "\xF0\xAF\xA0\x9E",
  "\xE5\x88\x87"                                     => "\xF0\xAF\xA1\x90",
  "\xE5\x88\x97"                                     => "\xEF\xA6\x9C",
  "\xE5\x88\xA9"                                     => "\xEF\xA7\x9D",
  "\xE5\x88\xBA"                                     => "\xEF\xA7\xBF",
  "\xE5\x88\xBB"                                     => "\xF0\xAF\xA0\xA0",
  "\xE5\x89\x86"                                     => "\xF0\xAF\xA0\xA1",
  "\xE5\x89\xB2"                                     => "\xF0\xAF\xA0\xA2",
  "\xE5\x89\xB7"                                     => "\xF0\xAF\xA0\xA3",
  "\xE5\x8A\x89"                                     => "\xEF\xA7\x87",
  "\xE5\x8A\x9B"                                     => "\xEF\xA6\x8A",
  "\xE5\x8A\xA3"                                     => "\xEF\xA6\x9D",
  "\xE5\x8A\xB3"                                     => "\xF0\xAF\xA6\x92",
  "\xE5\x8B\x87"                                     => "\xF0\xAF\xA0\xA5",
  "\xE5\x8B\x89"                                     => "\xEF\xA8\xB3",
  "\xE5\x8B\x92"                                     => "\xEF\xA5\x92",
  "\xE5\x8B\x9E"                                     => "\xEF\xA4\xAF",
  "\xE5\x8B\xA4"                                     => "\xF0\xAF\xA0\xA7",
  "\xE5\x8B\xB5"                                     => "\xEF\xA5\xBF",
  "\xE5\x8B\xBA"                                     => "\xF0\xAF\xA0\xA8",
  "\xE5\x8C\x85"                                     => "\xF0\xAF\xA0\xA9",
  "\xE5\x8C\x86"                                     => "\xF0\xAF\xA0\xAA",
  "\xE5\x8C\x97"                                     => "\xF0\xAF\xA0\xAB",
  "\xE5\x8C\xBF"                                     => "\xEF\xA7\xAB",
  "\xE5\x8D\x89"                                     => "\xF0\xAF\xA0\xAC",
  "\xE5\x8D\x91"                                     => "\xF0\xAF\xA0\xAD",
  "\xE5\x8D\x9A"                                     => "\xF0\xAF\xA0\xAE",
  "\xE5\x8D\xB3"                                     => "\xF0\xAF\xA0\xAF",
  "\xE5\x8D\xB5"                                     => "\xEF\xA4\x9C",
  "\xE5\x8D\xBD"                                     => "\xF0\xAF\xA0\xB0",
  "\xE5\x8F\x83"                                     => "\xEF\xA5\xAB",
  "\xE5\x8F\x8A"                                     => "\xF0\xAF\xA0\xB6",
  "\xE5\x8F\x9F"                                     => "\xF0\xAF\xA0\xB7",
  "\xE5\x8F\xA5"                                     => "\xEF\xA4\x86",
  "\xE5\x8F\xAB"                                     => "\xF0\xAF\xA0\xB9",
  "\xE5\x8F\xB1"                                     => "\xF0\xAF\xA0\xBA",
  "\xE5\x90\x86"                                     => "\xF0\xAF\xA0\xBB",
  "\xE5\x90\x8F"                                     => "\xEF\xA7\x9E",
  "\xE5\x90\x9D"                                     => "\xEF\xA7\xAD",
  "\xE5\x90\xB8"                                     => "\xF0\xAF\xA0\xBD",
  "\xE5\x91\x82"                                     => "\xEF\xA6\x80",
  "\xE5\x91\x88"                                     => "\xF0\xAF\xA0\xBE",
  "\xE5\x91\xA8"                                     => "\xF0\xAF\xA0\xBF",
  "\xE5\x92\x9E"                                     => "\xF0\xAF\xA0\xBC",
  "\xE5\x92\xA2"                                     => "\xF0\xAF\xA1\x80",
  "\xE5\x92\xBD"                                     => "\xEF\xA6\x9E",
  "\xE5\x93\xB6"                                     => "\xF0\xAF\xA1\x81",
  "\xE5\x94\x90"                                     => "\xF0\xAF\xA1\x82",
  "\xE5\x95\x93"                                     => "\xF0\xAF\xA1\x83",
  "\xE5\x95\x95"                                     => "\xEF\xA9\xB9",
  "\xE5\x95\xA3"                                     => "\xF0\xAF\xA1\x84",
  "\xE5\x96\x87"                                     => "\xEF\xA4\x8B",
  "\xE5\x96\x99"                                     => "\xEF\xA9\xBA",
  "\xE5\x96\x9D"                                     => "\xEF\xA8\xB6",
  "\xE5\x96\xAB"                                     => "\xF0\xAF\xA1\x88",
  "\xE5\x96\xB3"                                     => "\xF0\xAF\xA1\x89",
  "\xE5\x97\x80"                                     => "\xEF\xA8\x8D",
  "\xE5\x97\x82"                                     => "\xF0\xAF\xA1\x8A",
  "\xE5\x97\xA2"                                     => "\xEF\xA9\xBB",
  "\xE5\x98\x86"                                     => "\xEF\xA8\xB7",
  "\xE5\x99\x91"                                     => "\xF0\xAF\xA1\x8E",
  "\xE5\x99\xA8"                                     => "\xEF\xA8\xB8",
  "\xE5\x99\xB4"                                     => "\xF0\xAF\xA1\x8F",
  "\xE5\x9B\xB9"                                     => "\xEF\xA6\xA9",
  "\xE5\x9C\x96"                                     => "\xF0\xAF\xA1\x8B",
  "\xE5\x9C\x97"                                     => "\xF0\xAF\xA1\x8D",
  "\xE5\x9E\x8B"                                     => "\xF0\xAF\xA1\x95",
  "\xE5\x9F\x8E"                                     => "\xF0\xAF\xA1\x92",
  "\xE5\x9F\xB4"                                     => "\xF0\xAF\xA1\x93",
  "\xE5\xA0\x8D"                                     => "\xF0\xAF\xA1\x94",
  "\xE5\xA0\xB1"                                     => "\xF0\xAF\xA1\x97",
  "\xE5\xA0\xB2"                                     => "\xF0\xAF\xA1\x96",
  "\xE5\xA1\x80"                                     => "\xEF\xA8\xB9",
  "\xE5\xA1\x9A"                                     => "\xEF\xA9\xBC",
  "\xE5\xA1\x9E"                                     => "\xEF\xA5\xAC",
  "\xE5\xA2\xA8"                                     => "\xEF\xA8\xBA",
  "\xE5\xA2\xAC"                                     => "\xF0\xAF\xA1\x98",
  "\xE5\xA2\xB3"                                     => "\xEF\xA9\xBD",
  "\xE5\xA3\x98"                                     => "\xEF\xA5\x8A",
  "\xE5\xA3\x9F"                                     => "\xEF\xA5\x82",
  "\xE5\xA3\xAE"                                     => "\xF0\xAF\xA1\x91",
  "\xE5\xA3\xB2"                                     => "\xF0\xAF\xA1\x9A",
  "\xE5\xA3\xB7"                                     => "\xF0\xAF\xA1\x9B",
  "\xE5\xA4\x86"                                     => "\xF0\xAF\xA1\x9C",
  "\xE5\xA4\x9A"                                     => "\xF0\xAF\xA1\x9D",
  "\xE5\xA4\xA2"                                     => "\xF0\xAF\xA1\x9E",
  "\xE5\xA5\x84"                                     => "\xEF\xA9\xBE",
  "\xE5\xA5\x88"                                     => "\xEF\xA4\x8C",
  "\xE5\xA5\x91"                                     => "\xEF\xA4\x89",
  "\xE5\xA5\x94"                                     => "\xEF\xA9\xBF",
  "\xE5\xA5\xA2"                                     => "\xF0\xAF\xA1\x9F",
  "\xE5\xA5\xB3"                                     => "\xEF\xA6\x81",
  "\xE5\xA7\x98"                                     => "\xF0\xAF\xA1\xA5",
  "\xE5\xA7\xAC"                                     => "\xF0\xAF\xA1\xA2",
  "\xE5\xA8\x9B"                                     => "\xF0\xAF\xA1\xA3",
  "\xE5\xA8\xA7"                                     => "\xF0\xAF\xA1\xA4",
  "\xE5\xA9\xA2"                                     => "\xEF\xAA\x80",
  "\xE5\xA9\xA6"                                     => "\xF0\xAF\xA1\xA6",
  "\xE5\xAA\xB5"                                     => "\xF0\xAF\xA6\x86",
  "\xE5\xAC\x88"                                     => "\xF0\xAF\xA1\xA9",
  "\xE5\xAC\xA8"                                     => "\xEF\xAA\x81",
  "\xE5\xAE\x85"                                     => "\xEF\xA8\x84",
  "\xE5\xAF\x83"                                     => "\xF0\xAF\xA1\xAD",
  "\xE5\xAF\x98"                                     => "\xF0\xAF\xA1\xAE",
  "\xE5\xAF\xA7"                                     => "\xF0\xAF\xA1\xAF",
  "\xE5\xAF\xAE"                                     => "\xEF\xA6\xBC",
  "\xE5\xAF\xB3"                                     => "\xF0\xAF\xA1\xB0",
  "\xE5\xAF\xBF"                                     => "\xF0\xAF\xA1\xB2",
  "\xE5\xB0\x86"                                     => "\xF0\xAF\xA1\xB3",
  "\xE5\xB0\xA2"                                     => "\xF0\xAF\xA1\xB5",
  "\xE5\xB0\xBF"                                     => "\xEF\xA6\xBD",
  "\xE5\xB1\xA0"                                     => "\xF0\xAF\xA1\xB7",
  "\xE5\xB1\xA2"                                     => "\xEF\xA5\x8B",
  "\xE5\xB1\xA4"                                     => "\xEF\xA8\xBB",
  "\xE5\xB1\xA5"                                     => "\xEF\xA7\x9F",
  "\xE5\xB1\xAE"                                     => "\xEF\xA8\xBC",
  "\xE5\xB2\x8D"                                     => "\xF0\xAF\xA1\xBA",
  "\xE5\xB3\x80"                                     => "\xF0\xAF\xA1\xB9",
  "\xE5\xB4\x99"                                     => "\xEF\xA7\x95",
  "\xE5\xB5\x83"                                     => "\xF0\xAF\xA1\xBC",
  "\xE5\xB5\x90"                                     => "\xEF\xA4\xA1",
  "\xE5\xB5\xAB"                                     => "\xF0\xAF\xA1\xBF",
  "\xE5\xB5\xAE"                                     => "\xF0\xAF\xA1\xBE",
  "\xE5\xB5\xBC"                                     => "\xF0\xAF\xA2\x80",
  "\xE5\xB6\xB2"                                     => "\xF0\xAF\xA7\xB4",
  "\xE5\xB6\xBA"                                     => "\xEF\xA6\xAB",
  "\xE5\xB7\xA1"                                     => "\xF0\xAF\xA2\x81",
  "\xE5\xB7\xA2"                                     => "\xF0\xAF\xA2\x82",
  "\xE5\xB7\xBD"                                     => "\xF0\xAF\xA2\x84",
  "\xE5\xB8\xA8"                                     => "\xF0\xAF\xA2\x85",
  "\xE5\xB8\xBD"                                     => "\xF0\xAF\xA2\x86",
  "\xE5\xB9\xA9"                                     => "\xF0\xAF\xA2\x87",
  "\xE5\xB9\xB4"                                     => "\xEF\xA6\x8E",
  "\xE5\xBA\xA6"                                     => "\xEF\xA8\x81",
  "\xE5\xBA\xB0"                                     => "\xF0\xAF\xA2\x8B",
  "\xE5\xBA\xB3"                                     => "\xF0\xAF\xA2\x8C",
  "\xE5\xBA\xB6"                                     => "\xF0\xAF\xA2\x8D",
  "\xE5\xBB\x89"                                     => "\xEF\xA6\xA2",
  "\xE5\xBB\x8A"                                     => "\xF0\xAF\xA2\x8E",
  "\xE5\xBB\x92"                                     => "\xEF\xAA\x82",
  "\xE5\xBB\x93"                                     => "\xEF\xA8\x8B",
  "\xE5\xBB\x99"                                     => "\xEF\xAA\x83",
  "\xE5\xBB\xAC"                                     => "\xEF\xA6\x82",
  "\xE5\xBB\xBE"                                     => "\xF0\xAF\xA2\x90",
  "\xE5\xBC\x84"                                     => "\xEF\xA5\x83",
  "\xE5\xBD\x93"                                     => "\xF0\xAF\xA1\xB4",
  "\xE5\xBD\xA2"                                     => "\xF0\xAF\xA2\x99",
  "\xE5\xBD\xA9"                                     => "\xEF\xAA\x84",
  "\xE5\xBD\xAB"                                     => "\xF0\xAF\xA2\x9A",
  "\xE5\xBE\x8B"                                     => "\xEF\xA7\x98",
  "\xE5\xBE\x9A"                                     => "\xF0\xAF\xA2\x9C",
  "\xE5\xBE\xA9"                                     => "\xEF\xA5\xA6",
  "\xE5\xBE\xAD"                                     => "\xEF\xAA\x85",
  "\xE5\xBF\x8D"                                     => "\xF0\xAF\xA2\x9D",
  "\xE5\xBF\x97"                                     => "\xF0\xAF\xA2\x9E",
  "\xE5\xBF\xB5"                                     => "\xEF\xA6\xA3",
  "\xE5\xBF\xB9"                                     => "\xF0\xAF\xA2\x9F",
  "\xE6\x80\x92"                                     => "\xEF\xA5\xA0",
  "\xE6\x80\x9C"                                     => "\xEF\xA6\xAC",
  "\xE6\x82\x81"                                     => "\xF0\xAF\xA2\xA0",
  "\xE6\x82\x94"                                     => "\xF0\xAF\xA2\xA3",
  "\xE6\x83\x87"                                     => "\xF0\xAF\xA2\xA5",
  "\xE6\x83\x98"                                     => "\xEF\xAA\x86",
  "\xE6\x83\xA1"                                     => "\xEF\xA6\xB9",
  "\xE6\x84\x88"                                     => "\xEF\xAA\x88",
  "\xE6\x85\x84"                                     => "\xEF\xA7\x99",
  "\xE6\x85\x88"                                     => "\xF0\xAF\xA2\xA6",
  "\xE6\x85\x8C"                                     => "\xF0\xAF\xA2\xA7",
  "\xE6\x85\x8E"                                     => "\xF0\xAF\xA2\xA8",
  "\xE6\x85\xA0"                                     => "\xEF\xAA\x8A",
  "\xE6\x85\xA8"                                     => "\xEF\xA8\xBE",
  "\xE6\x85\xBA"                                     => "\xF0\xAF\xA2\xAA",
  "\xE6\x86\x8E"                                     => "\xEF\xA8\xBF",
  "\xE6\x86\x90"                                     => "\xEF\xA6\x8F",
  "\xE6\x86\xA4"                                     => "\xF0\xAF\xA2\xAD",
  "\xE6\x86\xAF"                                     => "\xF0\xAF\xA2\xAE",
  "\xE6\x86\xB2"                                     => "\xF0\xAF\xA2\xAC",
  "\xE6\x87\x9E"                                     => "\xF0\xAF\xA2\xAF",
  "\xE6\x87\xB2"                                     => "\xEF\xAA\x8B",
  "\xE6\x87\xB6"                                     => "\xF0\xAF\xA2\xB1",
  "\xE6\x88\x80"                                     => "\xEF\xA6\x90",
  "\xE6\x88\x90"                                     => "\xF0\xAF\xA2\xB2",
  "\xE6\x88\x9B"                                     => "\xF0\xAF\xA2\xB3",
  "\xE6\x88\xAE"                                     => "\xEF\xA7\x92",
  "\xE6\x88\xB4"                                     => "\xEF\xAA\x8C",
  "\xE6\x89\x9D"                                     => "\xF0\xAF\xA2\xB4",
  "\xE6\x8A\xB1"                                     => "\xF0\xAF\xA2\xB5",
  "\xE6\x8B\x89"                                     => "\xEF\xA4\xA5",
  "\xE6\x8B\x8F"                                     => "\xEF\xA5\x9B",
  "\xE6\x8B\x93"                                     => "\xEF\xA8\x82",
  "\xE6\x8B\x94"                                     => "\xF0\xAF\xA2\xB6",
  "\xE6\x8B\xBC"                                     => "\xF0\xAF\xA2\xBA",
  "\xE6\x8B\xBE"                                     => "\xEF\xA5\xB3",
  "\xE6\x8C\xBD"                                     => "\xF0\xAF\xA2\xB9",
  "\xE6\x8D\x90"                                     => "\xF0\xAF\xA2\xB7",
  "\xE6\x8D\xA8"                                     => "\xF0\xAF\xA2\xBB",
  "\xE6\x8D\xBB"                                     => "\xEF\xA6\xA4",
  "\xE6\x8E\x83"                                     => "\xF0\xAF\xA2\xBC",
  "\xE6\x8E\xA0"                                     => "\xEF\xA5\xB5",
  "\xE6\x8E\xA9"                                     => "\xF0\xAF\xA3\x81",
  "\xE6\x8F\x84"                                     => "\xEF\xAA\x8D",
  "\xE6\x8F\x85"                                     => "\xF0\xAF\xA3\x80",
  "\xE6\x8F\xA4"                                     => "\xF0\xAF\xA2\xBD",
  "\xE6\x90\x9C"                                     => "\xEF\xAA\x8E",
  "\xE6\x90\xA2"                                     => "\xF0\xAF\xA2\xBF",
  "\xE6\x91\x92"                                     => "\xEF\xAA\x8F",
  "\xE6\x91\xA9"                                     => "\xF0\xAF\xA3\x83",
  "\xE6\x91\xB7"                                     => "\xF0\xAF\xA3\x86",
  "\xE6\x91\xBE"                                     => "\xF0\xAF\xA3\x84",
  "\xE6\x92\x9A"                                     => "\xEF\xA6\x91",
  "\xE6\x92\x9D"                                     => "\xF0\xAF\xA3\x85",
  "\xE6\x93\x84"                                     => "\xEF\xA4\xB0",
  "\xE6\x95\x8F"                                     => "\xF0\xAF\xA3\x88",
  "\xE6\x95\x96"                                     => "\xEF\xAA\x90",
  "\xE6\x95\xAC"                                     => "\xF0\xAF\xA3\x89",
  "\xE6\x95\xB8"                                     => "\xEF\xA5\xA9",
  "\xE6\x96\x99"                                     => "\xEF\xA6\xBE",
  "\xE6\x97\x85"                                     => "\xEF\xA6\x83",
  "\xE6\x97\xA2"                                     => "\xEF\xA9\x82",
  "\xE6\x97\xA3"                                     => "\xF0\xAF\xA3\x8B",
  "\xE6\x98\x93"                                     => "\xEF\xA7\xA0",
  "\xE6\x99\x89"                                     => "\xF0\xAF\xA3\x8D",
  "\xE6\x99\xB4"                                     => "\xEF\xAA\x91",
  "\xE6\x9A\x88"                                     => "\xEF\xA7\x85",
  "\xE6\x9A\x91"                                     => "\xF0\xAF\xA3\x8F",
  "\xE6\x9A\x9C"                                     => "\xF0\xAF\xA3\x95",
  "\xE6\x9A\xB4"                                     => "\xEF\xA8\x86",
  "\xE6\x9B\x86"                                     => "\xEF\xA6\x8B",
  "\xE6\x9B\xB4"                                     => "\xEF\xA4\x81",
  "\xE6\x9B\xB8"                                     => "\xF0\xAF\xA3\x8C",
  "\xE6\x9C\x80"                                     => "\xF0\xAF\xA3\x94",
  "\xE6\x9C\x97"                                     => "\xF0\xAF\xA3\x98",
  "\xE6\x9C\x9B"                                     => "\xEF\xAA\x93",
  "\xE6\x9C\xA1"                                     => "\xF0\xAF\xA3\x9A",
  "\xE6\x9D\x8E"                                     => "\xEF\xA7\xA1",
  "\xE6\x9D\x93"                                     => "\xF0\xAF\xA3\x9C",
  "\xE6\x9D\x96"                                     => "\xEF\xAA\x94",
  "\xE6\x9D\x9E"                                     => "\xF0\xAF\xA3\x9B",
  "\xE6\x9D\xBB"                                     => "\xEF\xA7\x88",
  "\xE6\x9E\x85"                                     => "\xF0\xAF\xA3\xA0",
  "\xE6\x9E\x97"                                     => "\xEF\xA7\xB4",
  "\xE6\x9F\xB3"                                     => "\xEF\xA7\x89",
  "\xE6\x9F\xBA"                                     => "\xF0\xAF\xA3\x9F",
  "\xE6\xA0\x97"                                     => "\xEF\xA7\x9A",
  "\xE6\xA0\x9F"                                     => "\xF0\xAF\xA3\xA5",
  "\xE6\xA1\x92"                                     => "\xF0\xAF\xA3\xA1",
  "\xE6\xA2\x81"                                     => "\xEF\xA5\xBA",
  "\xE6\xA2\x85"                                     => "\xEF\xA9\x84",
  "\xE6\xA2\x8E"                                     => "\xF0\xAF\xA3\xA4",
  "\xE6\xA2\xA8"                                     => "\xEF\xA7\xA2",
  "\xE6\xA4\x94"                                     => "\xF0\xAF\xA3\xA6",
  "\xE6\xA5\x82"                                     => "\xF0\xAF\xA3\xA8",
  "\xE6\xA6\xA3"                                     => "\xF0\xAF\xA3\xA9",
  "\xE6\xA7\xAA"                                     => "\xF0\xAF\xA3\xAA",
  "\xE6\xA8\x82"                                     => "\xEF\xA6\xBF",
  "\xE6\xA8\x93"                                     => "\xEF\xA5\x8C",
  "\xE6\xAA\xA8"                                     => "\xF0\xAF\xA3\xAB",
  "\xE6\xAB\x93"                                     => "\xEF\xA4\xB1",
  "\xE6\xAB\x9B"                                     => "\xF0\xAF\xA3\xAD",
  "\xE6\xAC\x84"                                     => "\xEF\xA4\x9D",
  "\xE6\xAC\xA1"                                     => "\xF0\xAF\xA3\xAF",
  "\xE6\xAD\x94"                                     => "\xF0\xAF\xA3\xB1",
  "\xE6\xAD\xB2"                                     => "\xF0\xAF\xA3\xB3",
  "\xE6\xAD\xB7"                                     => "\xEF\xA6\x8C",
  "\xE6\xAD\xB9"                                     => "\xEF\xAA\x95",
  "\xE6\xAE\x9F"                                     => "\xF0\xAF\xA3\xB4",
  "\xE6\xAE\xAE"                                     => "\xEF\xA6\xA5",
  "\xE6\xAE\xBA"                                     => "\xEF\xA5\xB0",
  "\xE6\xAE\xBB"                                     => "\xF0\xAF\xA3\xB6",
  "\xE6\xB1\x8E"                                     => "\xF0\xAF\xA3\xBA",
  "\xE6\xB1\xA7"                                     => "\xF0\xAF\xA3\xBE",
  "\xE6\xB2\x88"                                     => "\xEF\xA5\xB2",
  "\xE6\xB2\xBF"                                     => "\xF0\xAF\xA3\xBC",
  "\xE6\xB3\x8C"                                     => "\xEF\xA5\xA8",
  "\xE6\xB3\x8D"                                     => "\xF0\xAF\xA3\xBD",
  "\xE6\xB3\xA5"                                     => "\xEF\xA7\xA3",
  "\xE6\xB4\x96"                                     => "\xF0\xAF\xA3\xBF",
  "\xE6\xB4\x9B"                                     => "\xEF\xA4\x95",
  "\xE6\xB4\x9E"                                     => "\xEF\xA8\x85",
  "\xE6\xB4\xB4"                                     => "\xF0\xAF\xA4\x87",
  "\xE6\xB4\xBE"                                     => "\xF0\xAF\xA4\x80",
  "\xE6\xB5\x81"                                     => "\xEF\xA7\x8A",
  "\xE6\xB5\xA9"                                     => "\xF0\xAF\xA4\x83",
  "\xE6\xB5\xAA"                                     => "\xEF\xA4\xAA",
  "\xE6\xB5\xB7"                                     => "\xEF\xA9\x85",
  "\xE6\xB5\xB8"                                     => "\xF0\xAF\xA4\x84",
  "\xE6\xB6\x85"                                     => "\xF0\xAF\xA4\x85",
  "\xE6\xB7\x8B"                                     => "\xEF\xA7\xB5",
  "\xE6\xB7\x9A"                                     => "\xEF\xA5\x8D",
  "\xE6\xB7\xAA"                                     => "\xEF\xA7\x96",
  "\xE6\xB7\xB9"                                     => "\xF0\xAF\xA4\x8E",
  "\xE6\xB8\x9A"                                     => "\xEF\xA9\x86",
  "\xE6\xB8\xAF"                                     => "\xF0\xAF\xA4\x88",
  "\xE6\xB9\xAE"                                     => "\xF0\xAF\xA4\x89",
  "\xE6\xBA\x9C"                                     => "\xEF\xA7\x8B",
  "\xE6\xBA\xBA"                                     => "\xEF\xA7\xAC",
  "\xE6\xBB\x87"                                     => "\xF0\xAF\xA4\x8C",
  "\xE6\xBB\x8B"                                     => "\xF0\xAF\xA4\x8B",
  "\xE6\xBB\x91"                                     => "\xEF\xA4\x84",
  "\xE6\xBB\x9B"                                     => "\xEF\xAA\x98",
  "\xE6\xBC\x8F"                                     => "\xEF\xA5\x8E",
  "\xE6\xBC\xA2"                                     => "\xEF\xA9\x87",
  "\xE6\xBC\xA3"                                     => "\xEF\xA6\x92",
  "\xE6\xBD\xAE"                                     => "\xF0\xAF\xA4\x8F",
  "\xE6\xBF\x86"                                     => "\xF0\xAF\xA4\x92",
  "\xE6\xBF\xAB"                                     => "\xEF\xA4\xA2",
  "\xE6\xBF\xBE"                                     => "\xEF\xA6\x84",
  "\xE7\x80\x9B"                                     => "\xF0\xAF\xA4\x95",
  "\xE7\x80\x9E"                                     => "\xF0\xAF\xA4\x94",
  "\xE7\x80\xB9"                                     => "\xF0\xAF\xA4\x93",
  "\xE7\x81\x8A"                                     => "\xF0\xAF\xA4\x97",
  "\xE7\x81\xB0"                                     => "\xF0\xAF\xA0\xB5",
  "\xE7\x81\xB7"                                     => "\xF0\xAF\xA4\x99",
  "\xE7\x81\xBD"                                     => "\xF0\xAF\xA4\x98",
  "\xE7\x82\x99"                                     => "\xEF\xA7\xBB",
  "\xE7\x82\xAD"                                     => "\xF0\xAF\xA4\x9A",
  "\xE7\x83\x88"                                     => "\xEF\xA6\x9F",
  "\xE7\x83\x99"                                     => "\xEF\xA4\x96",
  "\xE7\x85\x85"                                     => "\xF0\xAF\xA4\x9C",
  "\xE7\x85\x89"                                     => "\xEF\xA6\x93",
  "\xE7\x85\xAE"                                     => "\xEF\xAA\x9C",
  "\xE7\x86\x9C"                                     => "\xF0\xAF\xA4\x9E",
  "\xE7\x87\x8E"                                     => "\xEF\xA7\x80",
  "\xE7\x87\x90"                                     => "\xEF\xA7\xAE",
  "\xE7\x88\x90"                                     => "\xEF\xA4\xB2",
  "\xE7\x88\x9B"                                     => "\xEF\xA4\x9E",
  "\xE7\x88\xA8"                                     => "\xF0\xAF\xA4\xA0",
  "\xE7\x88\xAB"                                     => "\xEF\xA9\x89",
  "\xE7\x88\xB5"                                     => "\xF0\xAF\xA4\xA1",
  "\xE7\x89\x90"                                     => "\xF0\xAF\xA4\xA2",
  "\xE7\x89\xA2"                                     => "\xEF\xA5\x86",
  "\xE7\x8A\x80"                                     => "\xF0\xAF\xA4\xA4",
  "\xE7\x8A\x95"                                     => "\xF0\xAF\xA4\xA5",
  "\xE7\x8A\xAF"                                     => "\xEF\xAA\x9F",
  "\xE7\x8B\x80"                                     => "\xEF\xA7\xBA",
  "\xE7\x8B\xBC"                                     => "\xEF\xA4\xAB",
  "\xE7\x8C\xAA"                                     => "\xEF\xA8\x96",
  "\xE7\x8D\xB5"                                     => "\xEF\xA6\xA7",
  "\xE7\x8D\xBA"                                     => "\xF0\xAF\xA4\xA8",
  "\xE7\x8E\x87"                                     => "\xEF\xA7\x9B",
  "\xE7\x8E\x8B"                                     => "\xF0\xAF\xA4\xA9",
  "\xE7\x8E\xA5"                                     => "\xF0\xAF\xA4\xAB",
  "\xE7\x8E\xB2"                                     => "\xEF\xA6\xAD",
  "\xE7\x8F\x9E"                                     => "\xEF\xA4\x97",
  "\xE7\x90\x86"                                     => "\xEF\xA7\xA4",
  "\xE7\x90\x89"                                     => "\xEF\xA7\x8C",
  "\xE7\x90\xA2"                                     => "\xEF\xA9\x8A",
  "\xE7\x91\x87"                                     => "\xF0\xAF\xA4\xAE",
  "\xE7\x91\x9C"                                     => "\xF0\xAF\xA4\xAF",
  "\xE7\x91\xA9"                                     => "\xEF\xA6\xAE",
  "\xE7\x91\xB1"                                     => "\xF0\xAF\xA4\xB0",
  "\xE7\x92\x85"                                     => "\xF0\xAF\xA4\xB1",
  "\xE7\x92\x89"                                     => "\xEF\xA6\x94",
  "\xE7\x92\x98"                                     => "\xEF\xA7\xAF",
  "\xE7\x93\x8A"                                     => "\xF0\xAF\xA4\xB2",
  "\xE7\x94\x86"                                     => "\xEF\xAA\xA2",
  "\xE7\x94\xA4"                                     => "\xF0\xAF\xA4\xB4",
  "\xE7\x94\xBB"                                     => "\xEF\xAA\xA3",
  "\xE7\x94\xBE"                                     => "\xF0\xAF\xA4\xB6",
  "\xE7\x95\x99"                                     => "\xEF\xA7\x8D",
  "\xE7\x95\xA5"                                     => "\xEF\xA5\xB6",
  "\xE7\x95\xB0"                                     => "\xEF\xA5\xA2",
  "\xE7\x97\xA2"                                     => "\xEF\xA7\xA5",
  "\xE7\x98\x90"                                     => "\xF0\xAF\xA4\xBA",
  "\xE7\x98\x9D"                                     => "\xEF\xAA\xA4",
  "\xE7\x98\x9F"                                     => "\xEF\xAA\xA5",
  "\xE7\x99\x82"                                     => "\xEF\xA7\x81",
  "\xE7\x99\xA9"                                     => "\xEF\xA4\x8E",
  "\xE7\x9B\x8A"                                     => "\xEF\xAA\xA6",
  "\xE7\x9B\x9B"                                     => "\xEF\xAA\xA7",
  "\xE7\x9B\xA7"                                     => "\xEF\xA4\xB3",
  "\xE7\x9B\xB4"                                     => "\xF0\xAF\xA5\x80",
  "\xE7\x9C\x81"                                     => "\xEF\xA5\xAD",
  "\xE7\x9C\x9E"                                     => "\xF0\xAF\xA5\x85",
  "\xE7\x9D\x80"                                     => "\xEF\xAA\xAA",
  "\xE7\x9D\x8A"                                     => "\xEF\xAA\xA9",
  "\xE7\x9E\x8B"                                     => "\xF0\xAF\xA5\x8A",
  "\xE7\x9E\xA7"                                     => "\xEF\xAA\x9D",
  "\xE7\xA1\x8E"                                     => "\xF0\xAF\xA5\x8E",
  "\xE7\xA1\xAB"                                     => "\xEF\xA7\x8E",
  "\xE7\xA2\x8C"                                     => "\xF0\xAF\xA5\x8F",
  "\xE7\xA2\x91"                                     => "\xEF\xA9\x8B",
  "\xE7\xA3\x8A"                                     => "\xEF\xA5\x87",
  "\xE7\xA3\x8C"                                     => "\xF0\xAF\xA5\x90",
  "\xE7\xA3\xBB"                                     => "\xEF\xA5\xA4",
  "\xE7\xA4\xAA"                                     => "\xEF\xA6\x85",
  "\xE7\xA4\xBC"                                     => "\xEF\xA8\x98",
  "\xE7\xA4\xBE"                                     => "\xEF\xA9\x8C",
  "\xE7\xA5\x88"                                     => "\xEF\xA9\x8E",
  "\xE7\xA5\x89"                                     => "\xEF\xA9\x8D",
  "\xE7\xA5\x90"                                     => "\xEF\xA9\x8F",
  "\xE7\xA5\x96"                                     => "\xEF\xA9\x90",
  "\xE7\xA5\x9D"                                     => "\xEF\xA9\x91",
  "\xE7\xA5\x9E"                                     => "\xEF\xA8\x99",
  "\xE7\xA5\xA5"                                     => "\xEF\xA8\x9A",
  "\xE7\xA5\xBF"                                     => "\xEF\xA4\xBC",
  "\xE7\xA6\x8D"                                     => "\xEF\xA9\x92",
  "\xE7\xA6\x8E"                                     => "\xEF\xA9\x93",
  "\xE7\xA6\x8F"                                     => "\xEF\xA8\x9B",
  "\xE7\xA6\xAE"                                     => "\xEF\xA6\xB6",
  "\xE7\xA7\x8A"                                     => "\xEF\xA6\x95",
  "\xE7\xA7\xAB"                                     => "\xF0\xAF\xA5\x97",
  "\xE7\xA8\x9C"                                     => "\xEF\xA5\x96",
  "\xE7\xA9\x80"                                     => "\xF0\xAF\xA5\x99",
  "\xE7\xA9\x8A"                                     => "\xF0\xAF\xA5\x9A",
  "\xE7\xA9\x8F"                                     => "\xF0\xAF\xA5\x9B",
  "\xE7\xAA\x81"                                     => "\xEF\xA9\x95",
  "\xE7\xAA\xB1"                                     => "\xEF\xAA\xAC",
  "\xE7\xAB\x8B"                                     => "\xEF\xA7\xB7",
  "\xE7\xAB\xAE"                                     => "\xF0\xAF\xA5\x9F",
  "\xE7\xAC\xA0"                                     => "\xEF\xA7\xB8",
  "\xE7\xAF\x80"                                     => "\xEF\xAA\xAD",
  "\xE7\xAF\x86"                                     => "\xF0\xAF\xA5\xA2",
  "\xE7\xAF\x89"                                     => "\xF0\xAF\xA5\xA3",
  "\xE7\xB0\xBE"                                     => "\xEF\xA6\xA6",
  "\xE7\xB1\xA0"                                     => "\xEF\xA5\x84",
  "\xE7\xB1\xBB"                                     => "\xEF\xAA\xAE",
  "\xE7\xB2\x92"                                     => "\xEF\xA7\xB9",
  "\xE7\xB2\xBE"                                     => "\xEF\xA8\x9D",
  "\xE7\xB3\x92"                                     => "\xF0\xAF\xA5\xA6",
  "\xE7\xB3\x96"                                     => "\xEF\xA8\x83",
  "\xE7\xB3\xA3"                                     => "\xF0\xAF\xA5\xA9",
  "\xE7\xB3\xA7"                                     => "\xEF\xA5\xBB",
  "\xE7\xB3\xA8"                                     => "\xF0\xAF\xA5\xA8",
  "\xE7\xB4\x80"                                     => "\xF0\xAF\xA5\xAA",
  "\xE7\xB4\x90"                                     => "\xEF\xA7\x8F",
  "\xE7\xB4\xA2"                                     => "\xEF\xA5\xAA",
  "\xE7\xB4\xAF"                                     => "\xEF\xA5\x8F",
  "\xE7\xB5\x9B"                                     => "\xEF\xAA\xAF",
  "\xE7\xB5\xA3"                                     => "\xF0\xAF\xA5\xAC",
  "\xE7\xB6\xA0"                                     => "\xEF\xA4\xBD",
  "\xE7\xB6\xBE"                                     => "\xEF\xA5\x97",
  "\xE7\xB7\x87"                                     => "\xF0\xAF\xA5\xAE",
  "\xE7\xB7\xB4"                                     => "\xEF\xA6\x96",
  "\xE7\xB8\x82"                                     => "\xF0\xAF\xA5\xAF",
  "\xE7\xB8\x89"                                     => "\xEF\xA9\x98",
  "\xE7\xB8\xB7"                                     => "\xEF\xA5\x90",
  "\xE7\xB9\x81"                                     => "\xEF\xA9\x99",
  "\xE7\xB9\x85"                                     => "\xF0\xAF\xA5\xB0",
  "\xE7\xBC\xBE"                                     => "\xEF\xAA\xB1",
  "\xE7\xBD\xB2"                                     => "\xEF\xA9\x9A",
  "\xE7\xBD\xB9"                                     => "\xEF\xA7\xA6",
  "\xE7\xBD\xBA"                                     => "\xF0\xAF\xA5\xB6",
  "\xE7\xBE\x85"                                     => "\xEF\xA4\x8F",
  "\xE7\xBE\x95"                                     => "\xF0\xAF\xA5\xB8",
  "\xE7\xBE\x9A"                                     => "\xEF\xA6\xAF",
  "\xE7\xBE\xBD"                                     => "\xEF\xA8\x9E",
  "\xE7\xBF\xBA"                                     => "\xF0\xAF\xA5\xB9",
  "\xE8\x80\x81"                                     => "\xEF\xA4\xB4",
  "\xE8\x80\x85"                                     => "\xEF\xA9\x9B",
  "\xE8\x81\x86"                                     => "\xEF\xA6\xB0",
  "\xE8\x81\xA0"                                     => "\xF0\xAF\xA5\xBD",
  "\xE8\x81\xAF"                                     => "\xEF\xA6\x97",
  "\xE8\x81\xB0"                                     => "\xF0\xAF\xA5\xBF",
  "\xE8\x81\xBE"                                     => "\xEF\xA5\x85",
  "\xE8\x82\x8B"                                     => "\xEF\xA5\x93",
  "\xE8\x82\xAD"                                     => "\xF0\xAF\xA3\x96",
  "\xE8\x82\xB2"                                     => "\xF0\xAF\xA6\x82",
  "\xE8\x84\x83"                                     => "\xF0\xAF\xA6\x83",
  "\xE8\x84\xBE"                                     => "\xF0\xAF\xA6\x85",
  "\xE8\x87\x98"                                     => "\xEF\xA4\xA6",
  "\xE8\x87\xA8"                                     => "\xEF\xA7\xB6",
  "\xE8\x87\xAD"                                     => "\xEF\xA9\x9C",
  "\xE8\x88\x81"                                     => "\xF0\xAF\xA2\x93",
  "\xE8\x88\x84"                                     => "\xF0\xAF\xA6\x8C",
  "\xE8\x89\xAF"                                     => "\xEF\xA5\xBC",
  "\xE8\x8A\x8B"                                     => "\xF0\xAF\xA6\x90",
  "\xE8\x8A\x91"                                     => "\xF0\xAF\xA6\x8F",
  "\xE8\x8A\x9D"                                     => "\xF0\xAF\xA6\x91",
  "\xE8\x8A\xB1"                                     => "\xF0\xAF\xA6\x93",
  "\xE8\x8A\xB3"                                     => "\xF0\xAF\xA6\x94",
  "\xE8\x8A\xBD"                                     => "\xF0\xAF\xA6\x95",
  "\xE8\x8B\xA5"                                     => "\xEF\xA5\xB4",
  "\xE8\x8B\xA6"                                     => "\xF0\xAF\xA6\x96",
  "\xE8\x8C\x9D"                                     => "\xF0\xAF\xA6\x99",
  "\xE8\x8C\xA3"                                     => "\xF0\xAF\xA6\x9C",
  "\xE8\x8C\xB6"                                     => "\xEF\xA7\xBE",
  "\xE8\x8D\x92"                                     => "\xEF\xAA\xB3",
  "\xE8\x8D\x93"                                     => "\xF0\xAF\xA6\xA0",
  "\xE8\x8D\xA3"                                     => "\xF0\xAF\xA6\x9A",
  "\xE8\x8E\xAD"                                     => "\xF0\xAF\xA6\x9B",
  "\xE8\x8E\xBD"                                     => "\xF0\xAF\xA6\x9D",
  "\xE8\x8F\x89"                                     => "\xEF\xA4\xBE",
  "\xE8\x8F\x8A"                                     => "\xF0\xAF\xA6\xA1",
  "\xE8\x8F\x8C"                                     => "\xF0\xAF\xA6\xA2",
  "\xE8\x8F\x9C"                                     => "\xF0\xAF\xA6\xA3",
  "\xE8\x8F\xA7"                                     => "\xF0\xAF\xA6\x9E",
  "\xE8\x8F\xAF"                                     => "\xEF\xAA\xB4",
  "\xE8\x8F\xB1"                                     => "\xEF\xA5\x98",
  "\xE8\x90\xBD"                                     => "\xEF\xA4\x98",
  "\xE8\x91\x89"                                     => "\xEF\xA5\xAE",
  "\xE8\x91\x97"                                     => "\xF0\xAF\xA6\x9F",
  "\xE8\x93\xAE"                                     => "\xEF\xA6\x99",
  "\xE8\x93\xB1"                                     => "\xF0\xAF\xA6\xA8",
  "\xE8\x93\xB3"                                     => "\xF0\xAF\xA6\xA9",
  "\xE8\x93\xBC"                                     => "\xEF\xA7\x82",
  "\xE8\x94\x96"                                     => "\xF0\xAF\xA6\xAA",
  "\xE8\x95\xA4"                                     => "\xF0\xAF\xA6\xAC",
  "\xE8\x97\x8D"                                     => "\xEF\xA4\xA3",
  "\xE8\x97\xBA"                                     => "\xEF\xA7\xB0",
  "\xE8\x98\x86"                                     => "\xEF\xA4\xB5",
  "\xE8\x98\x92"                                     => "\xEF\xA8\xA0",
  "\xE8\x98\xAD"                                     => "\xEF\xA4\x9F",
  "\xE8\x98\xBF"                                     => "\xEF\xA4\x90",
  "\xE8\x99\x90"                                     => "\xF0\xAF\xA6\xB3",
  "\xE8\x99\x9C"                                     => "\xF0\xAF\xA6\xB4",
  "\xE8\x99\xA7"                                     => "\xF0\xAF\xA6\xB5",
  "\xE8\x99\xA9"                                     => "\xF0\xAF\xA6\xB6",
  "\xE8\x9A\x88"                                     => "\xF0\xAF\xA6\xB8",
  "\xE8\x9A\xA9"                                     => "\xF0\xAF\xA6\xB7",
  "\xE8\x9B\xA2"                                     => "\xF0\xAF\xA6\xBA",
  "\xE8\x9C\x8E"                                     => "\xF0\xAF\xA6\xB9",
  "\xE8\x9C\xA8"                                     => "\xF0\xAF\xA6\xBC",
  "\xE8\x9D\xAB"                                     => "\xF0\xAF\xA6\xBD",
  "\xE8\x9D\xB9"                                     => "\xEF\xAA\xB5",
  "\xE8\x9E\x86"                                     => "\xF0\xAF\xA6\xBE",
  "\xE8\x9E\xBA"                                     => "\xEF\xA4\x91",
  "\xE8\x9F\xA1"                                     => "\xF0\xAF\xA7\x80",
  "\xE8\xA0\x81"                                     => "\xF0\xAF\xA7\x81",
  "\xE8\xA0\x9F"                                     => "\xEF\xA4\xA7",
  "\xE8\xA1\x8C"                                     => "\xEF\xA8\x88",
  "\xE8\xA1\xA0"                                     => "\xF0\xAF\xA7\x83",
  "\xE8\xA1\xA3"                                     => "\xF0\xAF\xA7\x84",
  "\xE8\xA3\x82"                                     => "\xEF\xA6\xA0",
  "\xE8\xA3\x8F"                                     => "\xEF\xA7\xA7",
  "\xE8\xA3\x97"                                     => "\xF0\xAF\xA7\x86",
  "\xE8\xA3\x9E"                                     => "\xF0\xAF\xA7\x87",
  "\xE8\xA3\xA1"                                     => "\xEF\xA7\xA8",
  "\xE8\xA3\xB8"                                     => "\xEF\xA4\x92",
  "\xE8\xA3\xBA"                                     => "\xF0\xAF\xA7\x89",
  "\xE8\xA4\x90"                                     => "\xEF\xA9\xA0",
  "\xE8\xA5\x81"                                     => "\xEF\xAA\xB6",
  "\xE8\xA5\xA4"                                     => "\xEF\xA4\xA4",
  "\xE8\xA6\x86"                                     => "\xEF\xAA\xB7",
  "\xE8\xA6\x8B"                                     => "\xEF\xA8\x8A",
  "\xE8\xA6\x96"                                     => "\xEF\xAA\xB8",
  "\xE8\xAA\xA0"                                     => "\xF0\xAF\xA7\x8F",
  "\xE8\xAA\xAA"                                     => "\xEF\xA6\xA1",
  "\xE8\xAA\xBF"                                     => "\xEF\xAA\xB9",
  "\xE8\xAB\x8B"                                     => "\xEF\xAA\xBB",
  "\xE8\xAB\x92"                                     => "\xEF\xA5\xBD",
  "\xE8\xAB\x96"                                     => "\xEF\xA5\x81",
  "\xE8\xAB\xAD"                                     => "\xEF\xAA\xBE",
  "\xE8\xAB\xB8"                                     => "\xEF\xAA\xBA",
  "\xE8\xAB\xBE"                                     => "\xEF\xA5\x9D",
  "\xE8\xAC\x81"                                     => "\xEF\xA9\xA2",
  "\xE8\xAC\xB9"                                     => "\xEF\xA9\xA3",
  "\xE8\xAD\x98"                                     => "\xEF\xA7\xBC",
  "\xE8\xAE\x80"                                     => "\xEF\xA5\x9A",
  "\xE8\xAE\x8A"                                     => "\xEF\xAB\x80",
  "\xE8\xB1\x88"                                     => "\xEF\xA4\x80",
  "\xE8\xB1\x95"                                     => "\xF0\xAF\xA7\x92",
  "\xE8\xB2\xAB"                                     => "\xF0\xAF\xA7\x94",
  "\xE8\xB3\x81"                                     => "\xF0\xAF\xA7\x95",
  "\xE8\xB3\x82"                                     => "\xEF\xA5\x88",
  "\xE8\xB3\x88"                                     => "\xEF\xA4\x83",
  "\xE8\xB3\x93"                                     => "\xEF\xA9\xA4",
  "\xE8\xB4\x88"                                     => "\xEF\xA9\xA5",
  "\xE8\xB4\x9B"                                     => "\xF0\xAF\xA7\x96",
  "\xE8\xB5\xB7"                                     => "\xF0\xAF\xA7\x97",
  "\xE8\xB6\xBC"                                     => "\xF0\xAF\xA7\x9B",
  "\xE8\xB7\x8B"                                     => "\xF0\xAF\xA7\x9A",
  "\xE8\xB7\xAF"                                     => "\xEF\xA4\xB7",
  "\xE8\xB7\xB0"                                     => "\xF0\xAF\xA7\x9C",
  "\xE8\xBB\x8A"                                     => "\xEF\xA4\x82",
  "\xE8\xBB\x94"                                     => "\xF0\xAF\xA7\x9E",
  "\xE8\xBC\xA6"                                     => "\xEF\xA6\x98",
  "\xE8\xBC\xAA"                                     => "\xEF\xA7\x97",
  "\xE8\xBC\xB8"                                     => "\xF0\xAF\xA7\x9F",
  "\xE8\xBC\xBB"                                     => "\xEF\xA8\x87",
  "\xE8\xBD\xA2"                                     => "\xEF\xA6\x8D",
  "\xE8\xBE\x9E"                                     => "\xF0\xAF\xA6\x8D",
  "\xE8\xBE\xB0"                                     => "\xEF\xA5\xB1",
  "\xE8\xBE\xB6"                                     => "\xEF\xA9\xA6",
  "\xE9\x80\xA3"                                     => "\xEF\xA6\x9A",
  "\xE9\x80\xB8"                                     => "\xEF\xA8\xA5",
  "\xE9\x81\xB2"                                     => "\xEF\xAB\x83",
  "\xE9\x81\xBC"                                     => "\xEF\xA7\x83",
  "\xE9\x82\x8F"                                     => "\xEF\xA4\x93",
  "\xE9\x82\x94"                                     => "\xF0\xAF\xA7\xA2",
  "\xE9\x83\x8E"                                     => "\xEF\xA4\xAC",
  "\xE9\x83\xB1"                                     => "\xF0\xAF\xA7\xA3",
  "\xE9\x83\xBD"                                     => "\xEF\xA8\xA6",
  "\xE9\x84\x91"                                     => "\xF0\xAF\xA7\xA4",
  "\xE9\x84\x9B"                                     => "\xF0\xAF\xA7\xA6",
  "\xE9\x85\xAA"                                     => "\xEF\xA4\x99",
  "\xE9\x86\x99"                                     => "\xEF\xAB\x84",
  "\xE9\x86\xB4"                                     => "\xEF\xA6\xB7",
  "\xE9\x87\x8C"                                     => "\xEF\xA7\xA9",
  "\xE9\x87\x8F"                                     => "\xEF\xA5\xBE",
  "\xE9\x87\x91"                                     => "\xEF\xA4\x8A",
  "\xE9\x88\xB4"                                     => "\xEF\xA6\xB1",
  "\xE9\x88\xB8"                                     => "\xF0\xAF\xA7\xA7",
  "\xE9\x89\xB6"                                     => "\xEF\xAB\x85",
  "\xE9\x89\xBC"                                     => "\xF0\xAF\xA7\xAA",
  "\xE9\x8B\x97"                                     => "\xF0\xAF\xA7\xA8",
  "\xE9\x8B\x98"                                     => "\xF0\xAF\xA7\xA9",
  "\xE9\x8C\x84"                                     => "\xEF\xA4\xBF",
  "\xE9\x8D\x8A"                                     => "\xEF\xA6\x9B",
  "\xE9\x8F\xB9"                                     => "\xF0\xAF\xA7\xAB",
  "\xE9\x90\x95"                                     => "\xF0\xAF\xA7\xAC",
  "\xE9\x96\x8B"                                     => "\xF0\xAF\xA7\xAE",
  "\xE9\x96\xAD"                                     => "\xEF\xA6\x86",
  "\xE9\x96\xB7"                                     => "\xF0\xAF\xA7\xB0",
  "\xE9\x98\xAE"                                     => "\xEF\xA7\x86",
  "\xE9\x99\x8B"                                     => "\xEF\xA5\x91",
  "\xE9\x99\x8D"                                     => "\xEF\xA8\x89",
  "\xE9\x99\xB5"                                     => "\xEF\xA5\x99",
  "\xE9\x99\xB8"                                     => "\xEF\xA7\x93",
  "\xE9\x99\xBC"                                     => "\xEF\xAB\x86",
  "\xE9\x9A\x86"                                     => "\xEF\xA7\x9C",
  "\xE9\x9A\xA3"                                     => "\xEF\xA7\xB1",
  "\xE9\x9A\xB8"                                     => "\xEF\xA6\xB8",
  "\xE9\x9B\x83"                                     => "\xF0\xAF\xA7\xB3",
  "\xE9\x9B\xA2"                                     => "\xEF\xA7\xAA",
  "\xE9\x9B\xA3"                                     => "\xEF\xA9\xA8",
  "\xE9\x9B\xB6"                                     => "\xEF\xA6\xB2",
  "\xE9\x9B\xB7"                                     => "\xEF\xA5\x89",
  "\xE9\x9C\xA3"                                     => "\xF0\xAF\xA7\xB5",
  "\xE9\x9C\xB2"                                     => "\xEF\xA4\xB8",
  "\xE9\x9D\x88"                                     => "\xEF\xA6\xB3",
  "\xE9\x9D\x96"                                     => "\xEF\xAB\x88",
  "\xE9\x9F\x9B"                                     => "\xEF\xAB\x89",
  "\xE9\x9F\xA0"                                     => "\xF0\xAF\xA7\xBA",
  "\xE9\x9F\xBF"                                     => "\xEF\xA9\xA9",
  "\xE9\xA0\x8B"                                     => "\xEF\xAB\x8B",
  "\xE9\xA0\x98"                                     => "\xEF\xA6\xB4",
  "\xE9\xA0\xA9"                                     => "\xF0\xAF\xA8\x80",
  "\xE9\xA0\xBB"                                     => "\xEF\xA9\xAA",
  "\xE9\xA1\x9E"                                     => "\xEF\xA7\x90",
  "\xE9\xA3\xA2"                                     => "\xF0\xAF\xA8\x82",
  "\xE9\xA3\xAF"                                     => "\xEF\xA8\xAA",
  "\xE9\xA3\xBC"                                     => "\xEF\xA8\xAB",
  "\xE9\xA4\xA8"                                     => "\xEF\xA8\xAC",
  "\xE9\xA4\xA9"                                     => "\xF0\xAF\xA8\x84",
  "\xE9\xA6\xA7"                                     => "\xF0\xAF\xA8\x85",
  "\xE9\xA7\x82"                                     => "\xF0\xAF\xA8\x86",
  "\xE9\xA7\xB1"                                     => "\xEF\xA4\x9A",
  "\xE9\xA7\xBE"                                     => "\xF0\xAF\xA8\x87",
  "\xE9\xA9\xAA"                                     => "\xEF\xA6\x87",
  "\xE9\xAC\x92"                                     => "\xF0\xAF\xA8\x8A",
  "\xE9\xAD\xAF"                                     => "\xEF\xA4\xB9",
  "\xE9\xB1\x80"                                     => "\xF0\xAF\xA8\x8B",
  "\xE9\xB1\x97"                                     => "\xEF\xA7\xB2",
  "\xE9\xB3\xBD"                                     => "\xF0\xAF\xA8\x8C",
  "\xE9\xB5\xA7"                                     => "\xF0\xAF\xA8\x8F",
  "\xE9\xB6\xB4"                                     => "\xEF\xA8\xAD",
  "\xE9\xB7\xBA"                                     => "\xEF\xA4\xBA",
  "\xE9\xB8\x9E"                                     => "\xEF\xA4\xA0",
  "\xE9\xB9\xBF"                                     => "\xEF\xA5\x80",
  "\xE9\xBA\x97"                                     => "\xEF\xA6\x88",
  "\xE9\xBA\x9F"                                     => "\xEF\xA7\xB3",
  "\xE9\xBA\xBB"                                     => "\xF0\xAF\xA8\x95",
  "\xE9\xBB\x8E"                                     => "\xEF\xA6\x89",
  "\xE9\xBB\xB9"                                     => "\xF0\xAF\xA8\x97",
  "\xE9\xBB\xBE"                                     => "\xF0\xAF\xA8\x98",
  "\xE9\xBC\x85"                                     => "\xF0\xAF\xA8\x99",
  "\xE9\xBC\x8F"                                     => "\xF0\xAF\xA8\x9A",
  "\xE9\xBC\x96"                                     => "\xF0\xAF\xA8\x9B",
  "\xE9\xBC\xBB"                                     => "\xF0\xAF\xA8\x9C",
  "\xE9\xBD\x83"                                     => "\xEF\xAB\x98",
  "\xE9\xBE\x8D"                                     => "\xEF\xA7\x84",
  "\xE9\xBE\x8E"                                     => "\xEF\xAB\x99",
  "\xE9\xBE\x9C"                                     => "\xEF\xAB\x8E",
  "\xEF\xA4\x88\xE9\xBE\x9C"                         => "\xEF\xA4\x87",
  "\xEF\xA9\x9E\xE8\x89\xB9"                         => "\xEF\xA9\x9D",
  "\xF0\x9D\x85\x97\xF0\x9D\x85\xA5"                 => "\xF0\x9D\x85\x9E",
  "\xF0\x9D\x85\x98\xF0\x9D\x85\xA5"                 => "\xF0\x9D\x85\x9F",
  "\xF0\x9D\x85\x98\xF0\x9D\x85\xA5\xF0\x9D\x85\xAE" => "\xF0\x9D\x85\xA0",
  "\xF0\x9D\x85\x98\xF0\x9D\x85\xA5\xF0\x9D\x85\xAF" => "\xF0\x9D\x85\xA1",
  "\xF0\x9D\x85\x98\xF0\x9D\x85\xA5\xF0\x9D\x85\xB0" => "\xF0\x9D\x85\xA2",
  "\xF0\x9D\x85\x98\xF0\x9D\x85\xA5\xF0\x9D\x85\xB1" => "\xF0\x9D\x85\xA3",
  "\xF0\x9D\x85\x98\xF0\x9D\x85\xA5\xF0\x9D\x85\xB2" => "\xF0\x9D\x85\xA4",
  "\xF0\x9D\x86\xB9\xF0\x9D\x85\xA5"                 => "\xF0\x9D\x86\xBB",
  "\xF0\x9D\x86\xB9\xF0\x9D\x85\xA5\xF0\x9D\x85\xAE" => "\xF0\x9D\x86\xBD",
  "\xF0\x9D\x86\xB9\xF0\x9D\x85\xA5\xF0\x9D\x85\xAF" => "\xF0\x9D\x86\xBF",
  "\xF0\x9D\x86\xBA\xF0\x9D\x85\xA5"                 => "\xF0\x9D\x86\xBC",
  "\xF0\x9D\x86\xBA\xF0\x9D\x85\xA5\xF0\x9D\x85\xAE" => "\xF0\x9D\x86\xBE",
  "\xF0\x9D\x86\xBA\xF0\x9D\x85\xA5\xF0\x9D\x85\xAF" => "\xF0\x9D\x87\x80",
  "\xF0\xA0\x84\xA2"                                 => "\xF0\xAF\xA0\x83",
  "\xF0\xA0\x94\x9C"                                 => "\xF0\xAF\xA0\x92",
  "\xF0\xA0\x94\xA5"                                 => "\xF0\xAF\xA4\x9B",
  "\xF0\xA0\x95\x8B"                                 => "\xF0\xAF\xA0\x96",
  "\xF0\xA0\x98\xBA"                                 => "\xF0\xAF\xA0\x8D",
  "\xF0\xA0\xA0\x84"                                 => "\xF0\xAF\xA7\x99",
  "\xF0\xA0\xA3\x9E"                                 => "\xF0\xAF\xA7\x9D",
  "\xF0\xA0\xA8\xAC"                                 => "\xF0\xAF\xA0\xB4",
  "\xF0\xA0\xAD\xA3"                                 => "\xF0\xAF\xA0\xB8",
  "\xF0\xA1\x93\xA4"                                 => "\xF0\xAF\xA1\x99",
  "\xF0\xA1\x9A\xA8"                                 => "\xF0\xAF\xA1\xA0",
  "\xF0\xA1\x9B\xAA"                                 => "\xF0\xAF\xA1\xA1",
  "\xF0\xA1\xA7\x88"                                 => "\xF0\xAF\xA1\xAC",
  "\xF0\xA1\xAC\x98"                                 => "\xF0\xAF\xA1\xB1",
  "\xF0\xA1\xB4\x8B"                                 => "\xF0\xAF\xA3\xB8",
  "\xF0\xA1\xB7\xA4"                                 => "\xF0\xAF\xA1\xBB",
  "\xF0\xA1\xB7\xA6"                                 => "\xF0\xAF\xA1\xBD",
  "\xF0\xA2\x86\x83"                                 => "\xF0\xAF\xA2\x89",
  "\xF0\xA2\x86\x9F"                                 => "\xF0\xAF\xA4\xB9",
  "\xF0\xA2\x9B\x94"                                 => "\xF0\xAF\xA2\xA4",
  "\xF0\xA2\xA1\x84"                                 => "\xEF\xAB\x90",
  "\xF0\xA2\xA1\x8A"                                 => "\xEF\xAB\x8F",
  "\xF0\xA2\xAC\x8C"                                 => "\xF0\xAF\xA2\xB8",
  "\xF0\xA2\xAF\xB1"                                 => "\xF0\xAF\xA2\xBE",
  "\xF0\xA3\x80\x8A"                                 => "\xF0\xAF\xA3\x8A",
  "\xF0\xA3\x8A\xB8"                                 => "\xF0\xAF\xA2\x97",
  "\xF0\xA3\x8D\x9F"                                 => "\xF0\xAF\xA6\x80",
  "\xF0\xA3\x8E\x93"                                 => "\xF0\xAF\xA6\x89",
  "\xF0\xA3\x8E\x9C"                                 => "\xF0\xAF\xA6\x8A",
  "\xF0\xA3\x8F\x83"                                 => "\xF0\xAF\xA3\x9D",
  "\xF0\xA3\x8F\x95"                                 => "\xEF\xAB\x91",
  "\xF0\xA3\x91\xAD"                                 => "\xF0\xAF\xA3\xA3",
  "\xF0\xA3\x9A\xA3"                                 => "\xF0\xAF\xA3\xAC",
  "\xF0\xA3\xA2\xA7"                                 => "\xF0\xAF\xA3\xB0",
  "\xF0\xA3\xAA\x8D"                                 => "\xF0\xAF\xA3\xB7",
  "\xF0\xA3\xAB\xBA"                                 => "\xF0\xAF\xA3\xB9",
  "\xF0\xA3\xB2\xBC"                                 => "\xF0\xAF\xA3\xBB",
  "\xF0\xA3\xB4\x9E"                                 => "\xF0\xAF\xA4\x86",
  "\xF0\xA3\xBB\x91"                                 => "\xF0\xAF\xA4\x8D",
  "\xF0\xA3\xBD\x9E"                                 => "\xF0\xAF\xA4\x90",
  "\xF0\xA3\xBE\x8E"                                 => "\xF0\xAF\xA4\x91",
  "\xF0\xA4\x89\xA3"                                 => "\xF0\xAF\xA4\x9D",
  "\xF0\xA4\x8E\xAB"                                 => "\xF0\xAF\xA4\x9F",
  "\xF0\xA4\x98\x88"                                 => "\xF0\xAF\xA4\xA3",
  "\xF0\xA4\x9C\xB5"                                 => "\xF0\xAF\xA4\xA6",
  "\xF0\xA4\xA0\x94"                                 => "\xF0\xAF\xA4\xA7",
  "\xF0\xA4\xB0\xB6"                                 => "\xF0\xAF\xA4\xB5",
  "\xF0\xA4\xB2\x92"                                 => "\xF0\xAF\xA4\xB7",
  "\xF0\xA4\xBE\xA1"                                 => "\xF0\xAF\xA4\xBB",
  "\xF0\xA4\xBE\xB8"                                 => "\xF0\xAF\xA4\xBC",
  "\xF0\xA5\x81\x84"                                 => "\xF0\xAF\xA4\xBD",
  "\xF0\xA5\x83\xB2"                                 => "\xF0\xAF\xA5\x82",
  "\xF0\xA5\x83\xB3"                                 => "\xF0\xAF\xA5\x81",
  "\xF0\xA5\x84\x99"                                 => "\xF0\xAF\xA5\x83",
  "\xF0\xA5\x84\xB3"                                 => "\xF0\xAF\xA5\x84",
  "\xF0\xA5\x89\x89"                                 => "\xEF\xAB\x95",
  "\xF0\xA5\x90\x9D"                                 => "\xF0\xAF\xA5\x8D",
  "\xF0\xA5\x98\xA6"                                 => "\xF0\xAF\xA5\x92",
  "\xF0\xA5\x9A\x9A"                                 => "\xF0\xAF\xA5\x94",
  "\xF0\xA5\x9B\x85"                                 => "\xF0\xAF\xA5\x95",
  "\xF0\xA5\xA5\xBC"                                 => "\xF0\xAF\xA5\x9C",
  "\xF0\xA5\xAE\xAB"                                 => "\xF0\xAF\xA5\xA1",
  "\xF0\xA5\xB2\x80"                                 => "\xF0\xAF\xA5\xA5",
  "\xF0\xA5\xB3\x90"                                 => "\xEF\xAB\x96",
  "\xF0\xA5\xBE\x86"                                 => "\xF0\xAF\xA5\xAB",
  "\xF0\xA6\x87\x9A"                                 => "\xF0\xAF\xA2\x98",
  "\xF0\xA6\x88\xA8"                                 => "\xF0\xAF\xA5\xB2",
  "\xF0\xA6\x89\x87"                                 => "\xF0\xAF\xA5\xB3",
  "\xF0\xA6\x8B\x99"                                 => "\xF0\xAF\xA5\xB5",
  "\xF0\xA6\x8C\xBE"                                 => "\xF0\xAF\xA5\xB7",
  "\xF0\xA6\x93\x9A"                                 => "\xF0\xAF\xA5\xBB",
  "\xF0\xA6\x94\xA3"                                 => "\xF0\xAF\xA5\xBC",
  "\xF0\xA6\x96\xA8"                                 => "\xF0\xAF\xA5\xBE",
  "\xF0\xA6\x9E\xA7"                                 => "\xF0\xAF\xA6\x87",
  "\xF0\xA6\x9E\xB5"                                 => "\xF0\xAF\xA6\x88",
  "\xF0\xA6\xAC\xBC"                                 => "\xF0\xAF\xA6\x97",
  "\xF0\xA6\xB0\xB6"                                 => "\xF0\xAF\xA6\xA4",
  "\xF0\xA6\xB3\x95"                                 => "\xF0\xAF\xA6\xA6",
  "\xF0\xA6\xB5\xAB"                                 => "\xF0\xAF\xA6\xA5",
  "\xF0\xA6\xBC\xAC"                                 => "\xF0\xAF\xA6\xAD",
  "\xF0\xA6\xBE\xB1"                                 => "\xF0\xAF\xA6\xB0",
  "\xF0\xA7\x83\x92"                                 => "\xF0\xAF\xA6\xB1",
  "\xF0\xA7\x8F\x8A"                                 => "\xF0\xAF\xA6\xAB",
  "\xF0\xA7\x99\xA7"                                 => "\xF0\xAF\xA7\x85",
  "\xF0\xA7\xA2\xAE"                                 => "\xF0\xAF\xA7\x8B",
  "\xF0\xA7\xA5\xA6"                                 => "\xF0\xAF\xA7\x8C",
  "\xF0\xA7\xB2\xA8"                                 => "\xF0\xAF\xA7\x93",
  "\xF0\xA7\xBB\x93"                                 => "\xEF\xAB\x97",
  "\xF0\xA7\xBC\xAF"                                 => "\xF0\xAF\xA7\x98",
  "\xF0\xA8\x97\x92"                                 => "\xF0\xAF\xA7\xA0",
  "\xF0\xA8\x97\xAD"                                 => "\xF0\xAF\xA7\xA1",
  "\xF0\xA8\x9C\xAE"                                 => "\xF0\xAF\xA7\xA5",
  "\xF0\xA8\xAF\xBA"                                 => "\xF0\xAF\xA7\xAD",
  "\xF0\xA8\xB5\xB7"                                 => "\xF0\xAF\xA7\xB1",
  "\xF0\xA9\x85\x85"                                 => "\xF0\xAF\xA7\xB6",
  "\xF0\xA9\x87\x9F"                                 => "\xF0\xAF\xA0\x9C",
  "\xF0\xA9\x88\x9A"                                 => "\xF0\xAF\xA7\xB7",
  "\xF0\xA9\x90\x8A"                                 => "\xF0\xAF\xA7\xBB",
  "\xF0\xA9\x92\x96"                                 => "\xF0\xAF\xA7\xBD",
  "\xF0\xA9\x96\xB6"                                 => "\xF0\xAF\xA8\x81",
  "\xF0\xA9\xAC\xB0"                                 => "\xF0\xAF\xA8\x89",
  "\xF0\xAA\x83\x8E"                                 => "\xF0\xAF\xA8\x90",
  "\xF0\xAA\x84\x85"                                 => "\xF0\xAF\xA8\x92",
  "\xF0\xAA\x88\x8E"                                 => "\xF0\xAF\xA8\x93",
  "\xF0\xAA\x8A\x91"                                 => "\xF0\xAF\xA8\x94",
  "\xF0\xAA\x8E\x92"                                 => "\xF0\xAF\xA2\x8F",
  "\xF0\xAA\x98\x80"                                 => "\xF0\xAF\xA8\x9D",
  "\xF0\xAF\xA0\xB3\xE5\x8D\xBF"                     => "\xF0\xAF\xA0\xB1",
  "\xF0\xAF\xA1\x86\xE5\x96\x84"                     => "\xF0\xAF\xA1\x85",
  "\xF0\xAF\xA1\xAB\xE5\xAC\xBE"                     => "\xF0\xAF\xA1\xAA",
  "\xF0\xAF\xA2\x92\xF0\xA2\x8C\xB1"                 => "\xF0\xAF\xA2\x91",
  "\xF0\xAF\xA2\x95\xE5\xBC\xA2"                     => "\xF0\xAF\xA2\x94",
  "\xF0\xAF\xA4\xAD\xE3\xBA\xB8"                     => "\xF0\xAF\xA4\xAC",
  "\xF0\xAF\xA5\x87\xE7\x9C\x9F"                     => "\xF0\xAF\xA5\x86",
  "\xF0\xAF\xA5\x9E\xF0\xA5\xAA\xA7"                 => "\xF0\xAF\xA5\x9D",
  "\xF0\xAF\xA7\xBF\xE9\xA0\x8B"                     => "\xF0\xAF\xA7\xBE",
);

our $regex = join '|', sort keys %table;
$regex = qr/($regex)/o;

1;