<script type="text/javascript">
function Page() {}
Page.prototype =
{
	services: "WIFI.PHYINF,PHYINF.WIFI",
	OnLoad: function() {},
	OnUnload: function() {},
	OnSubmitCallback: function (code, result) { return false; },

	wifip: null,
	defpin: '<?echo query("/runtime/devdata/pin");?>',
	curpin: null,
	dual_band: COMM_ToBOOL('<?=$FEATURE_DUAL_BAND?>'),	
	wifi_module: null,

	InitValue: function(xml)
	{
		PXML.doc = xml;
		this.wifi_module 	= PXML.FindModule("WIFI.PHYINF");
		this.phyinf 		= GPBT(this.wifi_module, "phyinf", "uid","BAND24G-1.1", false);
		this.wifip 			= XG(this.phyinf+"/wifi");
		this.wifip 			= GPBT(this.wifi_module+"/wifi", "entry", "uid", this.wifip, false);

		if (!this.wifip)
		{
			BODY.ShowAlert("Initial() ERROR!!!");
			return false;
		}
		
		var wps_enable 		= XG(this.wifip+"/wps/enable");
		var wps_configured  = XG(this.wifip+"/wps/configured");
		var lock_wifi_sec	= XG(this.wifip+"/wps/locksecurity");
		var str_info = "";
		
		OBJ("en_wps").checked = COMM_ToBOOL(wps_enable);
		OBJ("lock_wifi_security").checked = COMM_ToBOOL(lock_wifi_sec);
		if (XG(this.wifip+"/wps/pin")=="")
			this.curpin = OBJ("pin").innerHTML = this.defpin;
		else
			this.curpin = OBJ("pin").innerHTML = XG(this.wifip+"/wps/pin");
		this.OnClickEnWPS();
		this.OnClickLockSettingWPS();
				
		if(wps_enable == "1") 		str_info = "<?echo I18N("j","Enable");?>"; else str_info ="<?echo I18N("j","Disable");?>";
		if(wps_configured == "1") 	str_info +=  "/<?echo I18N("j","Configured");?>"; else str_info += "/<?echo I18N("j","Not Configured");?>";
		OBJ("wifi_info_str").innerHTML = str_info;
		
		if(this.dual_band)
		{
			this.phyinf2 	= GPBT(this.wifi_module, "phyinf", "uid","BAND5G-1.1", false);
			this.wifip2 	= XG(this.phyinf2+"/wifi");
			this.wifip2 	= GPBT(this.wifi_module+"/wifi", "entry", "uid", this.wifip2, false);
		}
		
		return true;
	},
	PreSubmit: function()
	{
		var lock_wps_security = OBJ("lock_wifi_security").checked ? "1":"0";
		
		XS(this.wifip+"/wps/enable", (OBJ("en_wps").checked)? "1":"0");
		XS(this.wifip+"/wps/locksecurity", lock_wps_security);
		
		if(this.dual_band)
		{
			XS(this.wifip2+"/wps/enable", (OBJ("en_wps").checked)? "1":"0");
			XS(this.wifip2+"/wps/locksecurity", lock_wps_security);
		}
		
		//check authtype, if we use radius server, then wps can't be enabled.
		//TODO : what if dual band ? 
		if(OBJ("en_wps").checked && this.OnCheckWPAEnterprise()==1)
		{
			OBJ("en_wps").checked		= false;
			BODY.ShowAlert("<?echo I18N("j", "WPS can't be enabled when WPA-Enterprise security is selected."). "\\n".
							I18N("j","Please select other security in SETUP --> WIRELESS SETTINGS to enable WPS.");?>");
			return null;
		}
		return PXML.doc;
	},
	IsDirty: null,
	Synchronize: function()
	{
		if (OBJ("pin").innerHTML!=this.curpin)
		{
			OBJ("mainform").setAttribute("modified", "true");
			XS(this.wifip+"/wps/pin", OBJ("pin").innerHTML);
			if(this.dual_band)
				XS(this.wifip2+"/wps/pin", OBJ("pin").innerHTML);
		}
	},
	// The above are MUST HAVE methods ...
	///////////////////////////////////////////////////////////////////////
	OnCheckWPAEnterprise:function()
	{
		var auth = XG(this.wifip+"/authtype");
		switch(auth)
		{
			case "WPA":
			case "WPA2":
			case "WPA+2":
			case "WPAEAP":
			case "WPA+2EAP":			
			case "WPA2EAP":
				return 1;
			default : 
				return 0;
		}
	}, 

	OnClickEnWPS: function()
	{
		var en_wlan = XG(this.phyinf+"/active");
		var en_wlan2 = XG(this.phyinf2+"/active");
		
		if(en_wlan == 0 && en_wlan2 == 0)
		{
			OBJ("en_wps").checked 		= false;
			OBJ("en_wps").disabled		= true;
		}
		
			if (XG(this.wifip+"/wps/configured")=="0")
				OBJ("reset_cfg").disabled = true;
			else
				OBJ("reset_cfg").disabled = false;
				
		if (OBJ("en_wps").checked )
		{
			OBJ("reset_pin").disabled	= false;
			OBJ("gen_pin").disabled		= false;
			OBJ("go_wps").disabled		= false;
			OBJ("lock_wifi_security").disabled	= false;
		}
		else
		{
			OBJ("reset_pin").disabled	= true;
			OBJ("gen_pin").disabled		= true;
			OBJ("go_wps").disabled		= true;
			OBJ("lock_wifi_security").disabled	= true;
		}
	},
	OnClickLockSettingWPS: function()
	{
		var configured = COMM_ToBOOL(XG(this.wifip+"/wps/configured"));
		var en_wlan = XG(this.phyinf+"/active"); 
		if (!configured)
		{
			OBJ("lock_wifi_security").checked = false; 
			OBJ("lock_wifi_security").disabled = true; 
		}
		else
		{
			if(OBJ("lock_wifi_security").checked || en_wlan!="1")	
				OBJ("reset_cfg").disabled 			= true;
			else 									
				OBJ("reset_cfg").disabled 			= false;
		}
	},	
	OnClickResetPIN: function()
	{
		OBJ("pin").innerHTML = this.defpin;
	},
	OnClickGenPIN: function()
	{
		var pin = "";
		var sum = 0;
		var check_sum = 0;
		var r = 0;
		for(var i=0; i<7; i++)
		{
			r = (Math.floor(Math.random()*9));
			pin += r;
			sum += parseInt(r, [10]) * (((i%2)==0) ? 3:1);
		}
		check_sum = (10-(sum%10))%10;
		pin += check_sum;
		OBJ("pin").innerHTML = pin;
	},
	OnClickResetCfg: function()
	{
		if (confirm("<?echo i18n("Are you sure you want to reset the device to Unconfigured?")."\\n".
					i18n("This will cause wireless settings to be lost.");?>"))
		{
			Service("RESETCFG.WIFI");
			//self.location='<?=$TEMP_MYNAME?>.php?r='+COMM_RandomStr(5);
			//BODY.OnReload();
			//OBJ("mainform").setAttribute("modified", "true");
			//BODY.OnSubmit();
			/*	
			OBJ("mainform").setAttribute("modified", "true");
			XS(this.wifip+"/ssid",			"dlink"	);
			XS(this.wifip+"/authtype",		"OPEN"	);
			XS(this.wifip+"/encrtype",		"NONE"	);
			XS(this.wifip+"/wps/configured","0"		);
			XS(this.wifip+"/wps/locksecurity", 0);
			
			if(this.dual_band)
			{
				XS(this.wifip2+"/ssid",			"dlink_media");
				XS(this.wifip2+"/authtype",		"OPEN"	);
				XS(this.wifip2+"/encrtype",		"NONE"	);
				XS(this.wifip2+"/wps/configured","0"	);
				XS(this.wifip2+"/wps/locksecurity", 0);
			}
			
			
			*/
		}
	}
}

function Service(svc)
{	
	var banner = "<?echo i18n("RESET WIFI CONFIG");?>...";
	var msgArray = ["<?echo i18n("Device is resetting wireless config. Please wait ... ");?>"];
	var sec = 10;
	var url = '<?=$TEMP_MYNAME?>.php?r='+COMM_RandomStr(5);
	var ajaxObj = GetAjaxObj("SERVICE");
	ajaxObj.createRequest();
	ajaxObj.onCallback = function (xml)
	{
		ajaxObj.release();
		if (xml.Get("/report/result")!="OK")
			BODY.ShowAlert("Internal ERROR!\nEVENT "+svc+": "+xml.Get("/report/message"));
		else
			BODY.ShowCountdown(banner, msgArray, sec, url);
		
	}
	ajaxObj.setHeader("Content-Type", "application/x-www-form-urlencoded");
	ajaxObj.sendRequest("service.cgi", "EVENT="+svc);
}

</script>
