/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 5F., No.36, Taiyuan St., Jhubei City,
 * Hsinchu County 302,
 * Taiwan, R.O.C.
 *
 * (c) Copyright, Ralink Technology, Inc.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 ***************************************************************************
 */

#ifndef GDMA_H
#define GDMA_H



/*
 * DEFINITIONS AND MACROS
 */
#if 0
#define MOD_VERSION 			"0.4"

#if defined (CONFIG_RALINK_RT3052)
#define MAX_GDMA_CHANNEL		8
#elif defined (CONFIG_RALINK_RT3883) || defined (CONFIG_RALINK_RT3352)
#define MAX_GDMA_CHANNEL		16
#else
#error Please Choose System Type
#endif
#endif

#define RALINK_GDMA_BASE			(0xbfb30000)
#define RALINK_GDMA_CTRL_BASE		(RALINK_GDMA_BASE)


#if 0
#if defined (CONFIG_RALINK_RT3052)
#define RALINK_GDMAISTS				(RALINK_GDMA_BASE + 0x80)
#define RALINK_GDMAGCT				(RALINK_GDMA_BASE + 0x88)
#elif defined (CONFIG_RALINK_RT3883) || defined (CONFIG_RALINK_RT3352)
#define RALINK_GDMA_UNMASKINT		(RALINK_GDMA_BASE + 0x200)
#define RALINK_GDMA_DONEINT			(RALINK_GDMA_BASE + 0x204)
#define RALINK_GDMA_GCT				(RALINK_GDMA_BASE + 0x220)
#endif
#endif

// frank added
#define RALINK_GDMAISTS				(RALINK_GDMA_BASE + 0x0)
#define RALINK_GDMAGCT				(RALINK_GDMA_BASE + 0x8)
#define RALINK_GDMA_UNMASKINT		(RALINK_GDMA_BASE + 0x200)
#define RALINK_GDMA_DONEINT			(RALINK_GDMA_BASE + 0x204)
#define RALINK_GDMA_GCT				(RALINK_GDMA_BASE + 0x220)

#if 0
#define GDMA_READ_REG(addr) 		le32_to_cpu(*(volatile u32 *)(addr))
#define GDMA_WRITE_REG(addr, val)  	*((volatile uint32_t *)(addr)) = cpu_to_le32(val)
#define GET_GDMA_IP_VER				(GDMA_READ_REG(RALINK_GDMA_GCT) & 0x6) >> 1 //GDMA_GCT[2:1]
#endif

#define GDMA_READ_REG(addr) 		(*(volatile u32 *)(addr))
#define GDMA_WRITE_REG(addr, val)  	*((volatile uint32_t *)(addr)) = (val)

#if 0
#define RALINK_IRQ_ADDR              RALINK_INTCL_BASE
#define RALINK_REG_INTENA            (RALINK_IRQ_ADDR + 0x34)
#define RALINK_REG_INTDIS            (RALINK_IRQ_ADDR + 0x38)
#endif

/* 
 * 12bytes=GDMA Channel n Source Address(4) +
 *         GDMA Channel n Destination Address(4) +
 *         GDMA Channel n Control Register(4)
 *
 */
#define GDMA_SRC_REG(ch)		(RALINK_GDMA_BASE + ch*16)
#define GDMA_DST_REG(ch)		(GDMA_SRC_REG(ch) + 4)
#define GDMA_CTRL_REG(ch)		(GDMA_DST_REG(ch) + 4)
#define GDMA_CTRL_REG1(ch)		(GDMA_CTRL_REG(ch) + 4)

//GDMA Interrupt Status Register
#if 0
#if defined (CONFIG_RALINK_RT3052)
#define UNMASK_INT_STATUS(ch)		(ch+16)
#elif defined (CONFIG_RALINK_RT3883) || defined (CONFIG_RALINK_RT3352)
#define UNMASK_INT_STATUS(ch)		(ch)
#endif
#define TXDONE_INT_STATUS(ch)		(ch)	
#endif

//Control Reg0
#define MODE_SEL_OFFSET				0
#define CH_EBL_OFFSET				1
#define CH_DONEINT_EBL_OFFSET		2
#define BRST_SIZE_OFFSET			3
#define DST_BRST_MODE_OFFSET		6
#define SRC_BRST_MODE_OFFSET		7
#define TRANS_CNT_OFFSET			16

//Control Reg1
#if 0
#if defined (CONFIG_RALINK_RT3052)
#define CH_UNMASKINT_EBL_OFFSET		4
#define NEXT_UNMASK_CH_OFFSET		1
#elif defined (CONFIG_RALINK_RT3883) || defined (CONFIG_RALINK_RT3352)
#define CH_UNMASKINT_EBL_OFFSET		1
#define NEXT_UNMASK_CH_OFFSET		3
#endif
#endif


#define COHERENT_INT_EBL_OFFSET		2
#define CH_MASK_OFFSET				0
// frank added
#define NEXT_UNMASK_CH_OFFSET		3

#if 0
#if defined (CONFIG_RALINK_RT3052)
//Control Reg0
#define DST_DMA_REQ_OFFSET		8
#define SRC_DMA_REQ_OFFSET		12
#elif defined (CONFIG_RALINK_RT3883) || defined (CONFIG_RALINK_RT3352)
//Control Reg1
#define DST_DMA_REQ_OFFSET		8
#define SRC_DMA_REQ_OFFSET		16
#endif
#endif

#define DST_DMA_REQ_OFFSET		8
#define SRC_DMA_REQ_OFFSET		16

//#define GDMA_DEBUG
#ifdef GDMA_DEBUG
#define GDMA_PRINT(fmt, args...) printk(KERN_INFO "GDMA: " fmt, ## args)
#else
#define GDMA_PRINT(fmt, args...) { }
#endif

/*
 * TYPEDEFS AND STRUCTURES
 */

enum GdmaBusterMode {
	INC_MODE=0,
	FIX_MODE=1
};

enum GdmaBusterSize {
	BUSTER_SIZE_4B=0, 	/* 1 transfer */
	BUSTER_SIZE_8B=1, 	/* 2 transfer */
	BUSTER_SIZE_16B=2,  	/* 4 transfer */
	BUSTER_SIZE_32B=3,  	/* 8 transfer */
	BUSTER_SIZE_64B=4  	/* 16 transfer */
};

enum GdmaDmaReqNum {
	DMA_NAND_REQ=0,	
	DMA_REQ1=1,
	DMA_REQ2=2,
	DMA_REQ3=3,
	DMA_REQ4=4,
	DMA_REQ5=5,	
	DMA_REQ6=6,
	DMA_REQ7=7,
	DMA_REQ8=8,
	DMA_REQ9=9,
	DMA_REQ10=10,
	DMA_REQ11=11,
	DMA_REQ12=12,
	DMA_REQ13=13,
	DMA_REQ14=14,
	DMA_REQ15=15,
	DMA_MEM_REQ=32
};


#define BURST_SIZE_4B 0 	/* 1 transfer */
#define BURST_SIZE_8B 1 	/* 2 transfer */
#define	BURST_SIZE_16B 2  	/* 4 transfer */
#define	BURST_SIZE_32B 3  	/* 8 transfer */
#define BURST_SIZE_64B 4  	/* 16 transfer */
#define SW_MODE 1
#define HW_MODE 0
#define DMA_REQMEM 0x20

#define TRN_FIX  1
#define TRN_INC 0


int _ra_nand_prepare_dma_pull(unsigned long dst, int len);
int _ra_nand_dma_pull(unsigned long dst, int len);
int _ra_nand_dma_push(unsigned long src, int len);


#endif
